/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinkRepository
extends Repository {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, File> artifact_to_file = new HashMap<String, File>();
    private Map<String, File> filesystem = new HashMap<String, File>();
    private Map<String, Artifact> snapshots = new HashMap<String, Artifact>();
    private Set<File> known = new HashSet<File>();

    LinkRepository(File root) {
        super(root, "MEMORY");
    }

    @Override
    public File archive(Artifact artifact, File file, byte[] manifest) {
        String key = artifact.toString();
        this.known.add(file);
        if (this.artifact_to_file.containsKey(key)) {
            Artifact old;
            LOGGER.debug("Maven file already exists for {}({}) at {}, ignoring duplicate.", (Object)file.getName(), (Object)artifact.toString(), (Object)this.artifact_to_file.get(key).getAbsolutePath());
            if (artifact.isSnapshot() && ((old = this.snapshots.get(key)) == null || old.compareVersion(artifact) < 0)) {
                LOGGER.debug("Overriding Snapshot {} -> {}", (Object)(old == null ? "null" : old.getTimestamp()), (Object)artifact.getTimestamp());
                this.snapshots.put(key, artifact);
                this.artifact_to_file.put(key, file);
                this.filesystem.put(artifact.getPath(), file);
            }
        } else {
            LOGGER.debug("Making maven link for {} in memory to {}.", (Object)key, (Object)file.getAbsolutePath());
            this.artifact_to_file.put(key, file);
            this.filesystem.put(artifact.getPath(), file);
            if (artifact.isSnapshot()) {
                this.snapshots.put(key, artifact);
            }
        }
        return file;
    }

    @Override
    public void filterLegacy(List<File> list) {
        list.removeIf(e -> this.known.contains(e));
    }

    @Override
    public Artifact resolve(Artifact artifact) {
        String key = artifact.toString();
        File file = this.artifact_to_file.get(key);
        if (file == null || !file.exists()) {
            return super.resolve(artifact);
        }
        return new Artifact(artifact, this, artifact.isSnapshot() ? artifact.getTimestamp() : null);
    }

    @Override
    public File getFile(String path) {
        return this.filesystem.containsKey(path) ? this.filesystem.get(path) : super.getFile(path);
    }
}

