/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDispatcher;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLLoginWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    static final ResourceLocation WRAPPER = new ResourceLocation("fml:loginwrapper");
    private EventNetworkChannel wrapperChannel = NetworkRegistry.ChannelBuilder.named(WRAPPER).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").eventNetworkChannel();

    FMLLoginWrapper() {
        this.wrapperChannel.addListener(this::wrapperReceived);
    }

    private <T extends NetworkEvent> void wrapperReceived(T packet) {
        if (packet instanceof NetworkEvent.ChannelRegistrationChangeEvent) {
            return;
        }
        NetworkEvent.Context wrappedContext = packet.getSource().get();
        PacketBuffer payload = packet.getPayload();
        ResourceLocation targetNetworkReceiver = FMLNetworkConstants.FML_HANDSHAKE_RESOURCE;
        PacketBuffer data = null;
        if (payload != null) {
            targetNetworkReceiver = payload.func_192575_l();
            int payloadLength = payload.func_150792_a();
            data = new PacketBuffer(payload.readBytes(payloadLength));
        }
        int loginSequence = packet.getLoginIndex();
        LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Recieved login wrapper packet event for channel {} with index {}", (Object)targetNetworkReceiver, (Object)loginSequence);
        NetworkEvent.Context context = new NetworkEvent.Context(wrappedContext.getNetworkManager(), wrappedContext.getDirection(), new PacketDispatcher((rl, buf) -> {
            LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Dispatching wrapped packet reply for channel {} with index {}", rl, (Object)loginSequence);
            wrappedContext.getPacketDispatcher().sendPacket(WRAPPER, this.wrapPacket((ResourceLocation)rl, (PacketBuffer)buf));
        }));
        NetworkEvent.LoginPayloadEvent loginPayloadEvent = new NetworkEvent.LoginPayloadEvent(data, () -> context, loginSequence);
        NetworkRegistry.findTarget(targetNetworkReceiver).ifPresent(ni -> {
            ni.dispatchLoginPacket(loginPayloadEvent);
            wrappedContext.setPacketHandled(context.getPacketHandled());
        });
    }

    private PacketBuffer wrapPacket(ResourceLocation rl, PacketBuffer buf) {
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer((int)buf.capacity()));
        pb.func_192572_a(rl);
        pb.func_150787_b(buf.readableBytes());
        pb.writeBytes((ByteBuf)buf);
        return pb;
    }

    void sendServerToClientLoginPacket(ResourceLocation resourceLocation, PacketBuffer buffer, int index, NetworkManager manager) {
        PacketBuffer pb = this.wrapPacket(resourceLocation, buffer);
        manager.func_179290_a(NetworkDirection.LOGIN_TO_CLIENT.buildPacket((Pair<PacketBuffer, Integer>)Pair.of((Object)pb, (Object)index), WRAPPER).getThis());
    }
}

