/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.TagsProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ForgeRegistryTagsProvider<T extends IForgeRegistryEntry<T>>
extends TagsProvider<T> {
    private static final Map<IForgeRegistry<?>, String> vanillaTypes = ImmutableMap.builder().put(ForgeRegistries.BLOCKS, (Object)"blocks").put(ForgeRegistries.ENTITIES, (Object)"entity_types").put(ForgeRegistries.FLUIDS, (Object)"fluids").put(ForgeRegistries.ITEMS, (Object)"items").build();
    private final String folder;

    private static <T extends IForgeRegistryEntry<T>> Registry<T> wrapRegistry(IForgeRegistry<T> registryIn) {
        if (!(registryIn instanceof ForgeRegistry)) {
            throw new IllegalArgumentException("Forge registry " + registryIn.getRegistryName() + " is not an instance of a ForgeRegistry");
        }
        ForgeRegistry forgeRegistry = (ForgeRegistry)registryIn;
        if (forgeRegistry.getTagFolder() == null && !vanillaTypes.containsKey(registryIn)) {
            throw new IllegalArgumentException("Forge registry " + registryIn.getRegistryName() + " does not have support for tags");
        }
        if (forgeRegistry.getDefaultKey() == null) {
            return GameData.getWrapper(forgeRegistry.getRegistryKey(), Lifecycle.experimental());
        }
        return GameData.getWrapper(forgeRegistry.getRegistryKey(), Lifecycle.experimental(), "default");
    }

    public ForgeRegistryTagsProvider(DataGenerator generatorIn, IForgeRegistry<T> registryIn, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(generatorIn, ForgeRegistryTagsProvider.wrapRegistry(registryIn), modId, existingFileHelper);
        String tagFolder = ((ForgeRegistry)registryIn).getTagFolder();
        this.folder = tagFolder == null ? vanillaTypes.get(registryIn) : tagFolder;
    }

    protected Path func_200431_a(ResourceLocation id) {
        return this.field_200433_a.func_200391_b().resolve("data/" + id.func_110624_b() + "/tags/" + this.folder + "/" + id.func_110623_a() + ".json");
    }

    protected String getTagFolder() {
        return this.folder;
    }
}

