/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MapDecoration {
    private final Type field_191181_a;
    private byte field_176115_b;
    private byte field_176116_c;
    private byte field_176114_d;
    private final ITextComponent field_204310_e;

    public MapDecoration(Type type, byte x, byte y, byte rotation, @Nullable ITextComponent customName) {
        this.field_191181_a = type;
        this.field_176115_b = x;
        this.field_176116_c = y;
        this.field_176114_d = rotation;
        this.field_204310_e = customName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public byte func_176110_a() {
        return this.field_191181_a.func_191163_a();
    }

    public Type func_191179_b() {
        return this.field_191181_a;
    }

    public byte func_176112_b() {
        return this.field_176115_b;
    }

    public byte func_176113_c() {
        return this.field_176116_c;
    }

    public byte func_176111_d() {
        return this.field_176114_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_191180_f() {
        return this.field_191181_a.func_191160_b();
    }

    @Nullable
    public ITextComponent func_204309_g() {
        return this.field_204310_e;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof MapDecoration)) {
            return false;
        }
        MapDecoration mapdecoration = (MapDecoration)p_equals_1_;
        if (this.field_191181_a != mapdecoration.field_191181_a) {
            return false;
        }
        if (this.field_176114_d != mapdecoration.field_176114_d) {
            return false;
        }
        if (this.field_176115_b != mapdecoration.field_176115_b) {
            return false;
        }
        if (this.field_176116_c != mapdecoration.field_176116_c) {
            return false;
        }
        return Objects.equals(this.field_204310_e, mapdecoration.field_204310_e);
    }

    public int hashCode() {
        int i = this.field_191181_a.func_191163_a();
        i = 31 * i + this.field_176115_b;
        i = 31 * i + this.field_176116_c;
        i = 31 * i + this.field_176114_d;
        return 31 * i + Objects.hashCode(this.field_204310_e);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean render(int index) {
        return false;
    }

    public static enum Type {
        PLAYER(false),
        FRAME(true),
        RED_MARKER(false),
        BLUE_MARKER(false),
        TARGET_X(true),
        TARGET_POINT(true),
        PLAYER_OFF_MAP(false),
        PLAYER_OFF_LIMITS(false),
        MANSION(true, 5393476),
        MONUMENT(true, 3830373),
        BANNER_WHITE(true),
        BANNER_ORANGE(true),
        BANNER_MAGENTA(true),
        BANNER_LIGHT_BLUE(true),
        BANNER_YELLOW(true),
        BANNER_LIME(true),
        BANNER_PINK(true),
        BANNER_GRAY(true),
        BANNER_LIGHT_GRAY(true),
        BANNER_CYAN(true),
        BANNER_PURPLE(true),
        BANNER_BLUE(true),
        BANNER_BROWN(true),
        BANNER_GREEN(true),
        BANNER_RED(true),
        BANNER_BLACK(true),
        RED_X(true);

        private final byte field_191175_k = (byte)this.ordinal();
        private final boolean field_191176_l;
        private final int field_191177_m;

        private Type(boolean renderedOnFrame) {
            this(renderedOnFrame, -1);
        }

        private Type(boolean renderedOnFrame, int mapColor) {
            this.field_191176_l = renderedOnFrame;
            this.field_191177_m = mapColor;
        }

        public byte func_191163_a() {
            return this.field_191175_k;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_191160_b() {
            return this.field_191176_l;
        }

        public boolean func_191162_c() {
            return this.field_191177_m >= 0;
        }

        public int func_191161_d() {
            return this.field_191177_m;
        }

        public static Type func_191159_a(byte iconByte) {
            return Type.values()[MathHelper.func_76125_a((int)iconByte, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

