/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BiomeAmbience {
    public static final Codec<BiomeAmbience> field_235204_a_ = RecordCodecBuilder.create(p_235215_0_ -> p_235215_0_.group((App)Codec.INT.fieldOf("fog_color").forGetter(p_235229_0_ -> p_235229_0_.field_235205_b_), (App)Codec.INT.fieldOf("water_color").forGetter(p_235227_0_ -> p_235227_0_.field_235206_c_), (App)Codec.INT.fieldOf("water_fog_color").forGetter(p_235225_0_ -> p_235225_0_.field_235207_d_), (App)Codec.INT.fieldOf("sky_color").forGetter(p_242532_0_ -> p_242532_0_.field_242523_e), (App)Codec.INT.optionalFieldOf("foliage_color").forGetter(p_244421_0_ -> p_244421_0_.field_242524_f), (App)Codec.INT.optionalFieldOf("grass_color").forGetter(p_244426_0_ -> p_244426_0_.field_242525_g), (App)GrassColorModifier.field_242542_d.optionalFieldOf("grass_color_modifier", (Object)GrassColorModifier.NONE).forGetter(p_242530_0_ -> p_242530_0_.field_242526_h), (App)ParticleEffectAmbience.field_235041_a_.optionalFieldOf("particle").forGetter(p_235223_0_ -> p_235223_0_.field_235208_e_), (App)SoundEvent.field_232678_a_.optionalFieldOf("ambient_sound").forGetter(p_235221_0_ -> p_235221_0_.field_235209_f_), (App)MoodSoundAmbience.field_235026_a_.optionalFieldOf("mood_sound").forGetter(p_235219_0_ -> p_235219_0_.field_235210_g_), (App)SoundAdditionsAmbience.field_235018_a_.optionalFieldOf("additions_sound").forGetter(p_235217_0_ -> p_235217_0_.field_235211_h_), (App)BackgroundMusicSelector.field_232656_a_.optionalFieldOf("music").forGetter(p_244420_0_ -> p_244420_0_.field_235212_i_)).apply((Applicative)p_235215_0_, BiomeAmbience::new));
    private final int field_235205_b_;
    private final int field_235206_c_;
    private final int field_235207_d_;
    private final int field_242523_e;
    private final Optional<Integer> field_242524_f;
    private final Optional<Integer> field_242525_g;
    private final GrassColorModifier field_242526_h;
    private final Optional<ParticleEffectAmbience> field_235208_e_;
    private final Optional<SoundEvent> field_235209_f_;
    private final Optional<MoodSoundAmbience> field_235210_g_;
    private final Optional<SoundAdditionsAmbience> field_235211_h_;
    private final Optional<BackgroundMusicSelector> field_235212_i_;

    private BiomeAmbience(int fogColor, int waterColor, int waterFogColor, int skyColor, Optional<Integer> foliageColor, Optional<Integer> grassColor, GrassColorModifier grassColorModifier, Optional<ParticleEffectAmbience> particle, Optional<SoundEvent> ambientSound, Optional<MoodSoundAmbience> moodSound, Optional<SoundAdditionsAmbience> additionsSound, Optional<BackgroundMusicSelector> music) {
        this.field_235205_b_ = fogColor;
        this.field_235206_c_ = waterColor;
        this.field_235207_d_ = waterFogColor;
        this.field_242523_e = skyColor;
        this.field_242524_f = foliageColor;
        this.field_242525_g = grassColor;
        this.field_242526_h = grassColorModifier;
        this.field_235208_e_ = particle;
        this.field_235209_f_ = ambientSound;
        this.field_235210_g_ = moodSound;
        this.field_235211_h_ = additionsSound;
        this.field_235212_i_ = music;
    }

    public int func_235213_a_() {
        return this.field_235205_b_;
    }

    public int func_235216_b_() {
        return this.field_235206_c_;
    }

    public int func_235218_c_() {
        return this.field_235207_d_;
    }

    public int func_242527_d() {
        return this.field_242523_e;
    }

    public Optional<Integer> func_242528_e() {
        return this.field_242524_f;
    }

    public Optional<Integer> func_242529_f() {
        return this.field_242525_g;
    }

    public GrassColorModifier func_242531_g() {
        return this.field_242526_h;
    }

    public Optional<ParticleEffectAmbience> func_235220_d_() {
        return this.field_235208_e_;
    }

    public Optional<SoundEvent> func_235222_e_() {
        return this.field_235209_f_;
    }

    public Optional<MoodSoundAmbience> func_235224_f_() {
        return this.field_235210_g_;
    }

    public Optional<SoundAdditionsAmbience> func_235226_g_() {
        return this.field_235211_h_;
    }

    public Optional<BackgroundMusicSelector> func_235228_h_() {
        return this.field_235212_i_;
    }

    public static enum GrassColorModifier implements IStringSerializable
    {
        NONE("none"){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public int func_241853_a(double x, double z, int grassColor) {
                return grassColor;
            }
        }
        ,
        DARK_FOREST("dark_forest"){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public int func_241853_a(double x, double z, int grassColor) {
                return (grassColor & 0xFEFEFE) + 2634762 >> 1;
            }
        }
        ,
        SWAMP("swamp"){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public int func_241853_a(double x, double z, int grassColor) {
                double d0 = Biome.field_180281_af.func_215464_a(x * 0.0225, z * 0.0225, false);
                return d0 < -0.1 ? 5011004 : 6975545;
            }
        };

        private final String field_242543_e;
        public static final Codec<GrassColorModifier> field_242542_d;
        private static final Map<String, GrassColorModifier> field_242544_f;

        @OnlyIn(value=Dist.CLIENT)
        public abstract int func_241853_a(double var1, double var3, int var5);

        private GrassColorModifier(String name) {
            this.field_242543_e = name;
        }

        public String func_242547_b() {
            return this.field_242543_e;
        }

        public String func_176610_l() {
            return this.field_242543_e;
        }

        public static GrassColorModifier func_242546_a(String name) {
            return field_242544_f.get(name);
        }

        static {
            field_242542_d = IStringSerializable.func_233023_a_(GrassColorModifier::values, GrassColorModifier::func_242546_a);
            field_242544_f = Arrays.stream(GrassColorModifier.values()).collect(Collectors.toMap(GrassColorModifier::func_242547_b, p_242545_0_ -> p_242545_0_));
        }
    }

    public static class Builder {
        private OptionalInt field_235230_a_ = OptionalInt.empty();
        private OptionalInt field_235231_b_ = OptionalInt.empty();
        private OptionalInt field_235232_c_ = OptionalInt.empty();
        private OptionalInt field_242533_d = OptionalInt.empty();
        private Optional<Integer> field_242534_e = Optional.empty();
        private Optional<Integer> field_242535_f = Optional.empty();
        private GrassColorModifier field_242536_g = GrassColorModifier.NONE;
        private Optional<ParticleEffectAmbience> field_235233_d_ = Optional.empty();
        private Optional<SoundEvent> field_235234_e_ = Optional.empty();
        private Optional<MoodSoundAmbience> field_235235_f_ = Optional.empty();
        private Optional<SoundAdditionsAmbience> field_235236_g_ = Optional.empty();
        private Optional<BackgroundMusicSelector> field_235237_h_ = Optional.empty();

        public Builder func_235239_a_(int fogColor) {
            this.field_235230_a_ = OptionalInt.of(fogColor);
            return this;
        }

        public Builder func_235246_b_(int waterColor) {
            this.field_235231_b_ = OptionalInt.of(waterColor);
            return this;
        }

        public Builder func_235248_c_(int waterFogColor) {
            this.field_235232_c_ = OptionalInt.of(waterFogColor);
            return this;
        }

        public Builder func_242539_d(int skyColor) {
            this.field_242533_d = OptionalInt.of(skyColor);
            return this;
        }

        public Builder func_242540_e(int foliageColor) {
            this.field_242534_e = Optional.of(foliageColor);
            return this;
        }

        public Builder func_242541_f(int grassColor) {
            this.field_242535_f = Optional.of(grassColor);
            return this;
        }

        public Builder func_242537_a(GrassColorModifier grassColorModifier) {
            this.field_242536_g = grassColorModifier;
            return this;
        }

        public Builder func_235244_a_(ParticleEffectAmbience particle) {
            this.field_235233_d_ = Optional.of(particle);
            return this;
        }

        public Builder func_235241_a_(SoundEvent ambientSound) {
            this.field_235234_e_ = Optional.of(ambientSound);
            return this;
        }

        public Builder func_235243_a_(MoodSoundAmbience moodSound) {
            this.field_235235_f_ = Optional.of(moodSound);
            return this;
        }

        public Builder func_235242_a_(SoundAdditionsAmbience additionsSound) {
            this.field_235236_g_ = Optional.of(additionsSound);
            return this;
        }

        public Builder func_235240_a_(BackgroundMusicSelector music) {
            this.field_235237_h_ = Optional.of(music);
            return this;
        }

        public BiomeAmbience func_235238_a_() {
            return new BiomeAmbience(this.field_235230_a_.orElseThrow(() -> new IllegalStateException("Missing 'fog' color.")), this.field_235231_b_.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.field_235232_c_.orElseThrow(() -> new IllegalStateException("Missing 'water fog' color.")), this.field_242533_d.orElseThrow(() -> new IllegalStateException("Missing 'sky' color.")), this.field_242534_e, this.field_242535_f, this.field_242536_g, this.field_235233_d_, this.field_235234_e_, this.field_235235_f_, this.field_235236_g_, this.field_235237_h_);
        }
    }
}

