/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.ArrayPalette;
import net.minecraft.util.palette.HashMapPalette;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PalettedContainer<T>
implements IResizeCallback<T> {
    private final IPalette<T> field_205521_b;
    private final IResizeCallback<T> field_205522_c = (p_205517_0_, p_205517_1_) -> 0;
    private final ObjectIntIdentityMap<T> field_205523_d;
    private final Function<CompoundNBT, T> field_205524_e;
    private final Function<T, CompoundNBT> field_205525_f;
    private final T field_205526_g;
    protected BitArray field_186021_b;
    private IPalette<T> field_186022_c;
    private int field_186024_e;
    private final ReentrantLock field_210461_j = new ReentrantLock();

    public void func_210459_b() {
        if (this.field_210461_j.isLocked() && !this.field_210461_j.isHeldByCurrentThread()) {
            String s = Thread.getAllStackTraces().keySet().stream().filter(Objects::nonNull).map(p_210458_0_ -> p_210458_0_.getName() + ": \n\tat " + Arrays.stream(p_210458_0_.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat "))).collect(Collectors.joining("\n"));
            CrashReport crashreport = new CrashReport("Writing into PalettedContainer from multiple threads", new IllegalStateException());
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Thread dumps");
            crashreportcategory.func_71507_a("Thread dumps", s);
            throw new ReportedException(crashreport);
        }
        this.field_210461_j.lock();
    }

    public void func_210460_c() {
        this.field_210461_j.unlock();
    }

    public PalettedContainer(IPalette<T> globalPaletteIn, ObjectIntIdentityMap<T> registryIn, Function<CompoundNBT, T> deserializerIn, Function<T, CompoundNBT> serializerIn, T defaultStateIn) {
        this.field_205521_b = globalPaletteIn;
        this.field_205523_d = registryIn;
        this.field_205524_e = deserializerIn;
        this.field_205525_f = serializerIn;
        this.field_205526_g = defaultStateIn;
        this.func_186012_b(4);
    }

    private static int func_186011_b(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    private void func_186012_b(int bitsIn) {
        this.setBits(bitsIn, false);
    }

    private void setBits(int bitsIn, boolean forceBits) {
        if (bitsIn != this.field_186024_e) {
            this.field_186024_e = bitsIn;
            if (this.field_186024_e <= 4) {
                this.field_186024_e = 4;
                this.field_186022_c = new ArrayPalette(this.field_205523_d, this.field_186024_e, (IResizeCallback)this, this.field_205524_e);
            } else if (this.field_186024_e < 9) {
                this.field_186022_c = new HashMapPalette(this.field_205523_d, this.field_186024_e, (IResizeCallback)this, this.field_205524_e, this.field_205525_f);
            } else {
                this.field_186022_c = this.field_205521_b;
                this.field_186024_e = MathHelper.func_151241_e((int)this.field_205523_d.func_186804_a());
                if (forceBits) {
                    this.field_186024_e = bitsIn;
                }
            }
            this.field_186022_c.func_186041_a(this.field_205526_g);
            this.field_186021_b = new BitArray(this.field_186024_e, 4096);
        }
    }

    public int onResize(int p_onResize_1_, T p_onResize_2_) {
        this.func_210459_b();
        BitArray bitarray = this.field_186021_b;
        IPalette<T> ipalette = this.field_186022_c;
        this.func_186012_b(p_onResize_1_);
        for (int i = 0; i < bitarray.func_188144_b(); ++i) {
            Object t = ipalette.func_186039_a(bitarray.func_188142_a(i));
            if (t == null) continue;
            this.func_186014_b(i, t);
        }
        int j = this.field_186022_c.func_186041_a(p_onResize_2_);
        this.func_210460_c();
        return j;
    }

    public T func_222641_a(int x, int y, int z, T state) {
        this.func_210459_b();
        T t = this.func_222643_a(PalettedContainer.func_186011_b(x, y, z), state);
        this.func_210460_c();
        return t;
    }

    public T func_222639_b(int x, int y, int z, T state) {
        return this.func_222643_a(PalettedContainer.func_186011_b(x, y, z), state);
    }

    protected T func_222643_a(int index, T state) {
        int i = this.field_186022_c.func_186041_a(state);
        int j = this.field_186021_b.func_219789_a(index, i);
        Object t = this.field_186022_c.func_186039_a(j);
        return (T)(t == null ? this.field_205526_g : t);
    }

    protected void func_186014_b(int index, T state) {
        int i = this.field_186022_c.func_186041_a(state);
        this.field_186021_b.func_188141_a(index, i);
    }

    public T func_186016_a(int x, int y, int z) {
        return this.func_186015_a(PalettedContainer.func_186011_b(x, y, z));
    }

    protected T func_186015_a(int index) {
        Object t = this.field_186022_c.func_186039_a(this.field_186021_b.func_188142_a(index));
        return (T)(t == null ? this.field_205526_g : t);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_186010_a(PacketBuffer buf) {
        this.func_210459_b();
        byte i = buf.readByte();
        if (this.field_186024_e != i) {
            this.setBits(i, true);
        }
        this.field_186022_c.func_186038_a(buf);
        buf.func_186873_b(this.field_186021_b.func_188143_a());
        this.func_210460_c();
        int regSize = MathHelper.func_151241_e((int)this.field_205523_d.func_186804_a());
        if (this.field_186022_c == this.field_205521_b && this.field_186024_e != regSize) {
            this.onResize(regSize, this.field_205526_g);
        }
    }

    public void func_186009_b(PacketBuffer buf) {
        this.func_210459_b();
        buf.writeByte(this.field_186024_e);
        this.field_186022_c.func_186037_b(buf);
        buf.func_186865_a(this.field_186021_b.func_188143_a());
        this.func_210460_c();
    }

    public void func_222642_a(ListNBT paletteNbt, long[] data) {
        this.func_210459_b();
        int i = Math.max(4, MathHelper.func_151241_e((int)paletteNbt.size()));
        if (i != this.field_186024_e) {
            this.func_186012_b(i);
        }
        this.field_186022_c.func_196968_a(paletteNbt);
        int j = data.length * 64 / 4096;
        if (this.field_186022_c == this.field_205521_b) {
            HashMapPalette ipalette = new HashMapPalette(this.field_205523_d, i, this.field_205522_c, this.field_205524_e, this.field_205525_f);
            ipalette.func_196968_a(paletteNbt);
            BitArray bitarray = new BitArray(i, 4096, data);
            for (int k = 0; k < 4096; ++k) {
                this.field_186021_b.func_188141_a(k, this.field_205521_b.func_186041_a(ipalette.func_186039_a(bitarray.func_188142_a(k))));
            }
        } else if (j == this.field_186024_e) {
            System.arraycopy(data, 0, this.field_186021_b.func_188143_a(), 0, data.length);
        } else {
            BitArray bitarray1 = new BitArray(j, 4096, data);
            for (int l = 0; l < 4096; ++l) {
                this.field_186021_b.func_188141_a(l, bitarray1.func_188142_a(l));
            }
        }
        this.func_210460_c();
    }

    public void func_196963_b(CompoundNBT compound, String paletteName, String paletteDataName) {
        this.func_210459_b();
        HashMapPalette hashmappalette = new HashMapPalette(this.field_205523_d, this.field_186024_e, this.field_205522_c, this.field_205524_e, this.field_205525_f);
        T t = this.field_205526_g;
        int i = hashmappalette.func_186041_a(this.field_205526_g);
        int[] aint = new int[4096];
        for (int j = 0; j < 4096; ++j) {
            T t1 = this.func_186015_a(j);
            if (t1 != t) {
                t = t1;
                i = hashmappalette.func_186041_a(t1);
            }
            aint[j] = i;
        }
        ListNBT listnbt = new ListNBT();
        hashmappalette.func_196969_b(listnbt);
        compound.func_218657_a(paletteName, (INBT)listnbt);
        int l = Math.max(4, MathHelper.func_151241_e((int)listnbt.size()));
        BitArray bitarray = new BitArray(l, 4096);
        for (int k = 0; k < aint.length; ++k) {
            bitarray.func_188141_a(k, aint[k]);
        }
        compound.func_197644_a(paletteDataName, bitarray.func_188143_a());
        this.func_210460_c();
    }

    public int func_186018_a() {
        return 1 + this.field_186022_c.func_186040_a() + PacketBuffer.func_150790_a(this.field_186021_b.func_188144_b()) + this.field_186021_b.func_188143_a().length * 8;
    }

    public boolean func_235963_a_(Predicate<T> p_235963_1_) {
        return this.field_186022_c.func_230341_a_(p_235963_1_);
    }

    public void func_225497_a(ICountConsumer<T> countConsumerIn) {
        Int2IntOpenHashMap int2intmap = new Int2IntOpenHashMap();
        this.field_186021_b.func_225421_a(arg_0 -> PalettedContainer.lambda$count$2((Int2IntMap)int2intmap, arg_0));
        int2intmap.int2IntEntrySet().forEach(p_225499_2_ -> countConsumerIn.accept(this.field_186022_c.func_186039_a(p_225499_2_.getIntKey()), p_225499_2_.getIntValue()));
    }

    private static /* synthetic */ void lambda$count$2(Int2IntMap int2intmap, int p_225498_1_) {
        int2intmap.put(p_225498_1_, int2intmap.get(p_225498_1_) + 1);
    }

    @FunctionalInterface
    public static interface ICountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

