/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import java.util.EnumSet;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vector3d
implements IPosition {
    public static final Vector3d field_186680_a = new Vector3d(0.0, 0.0, 0.0);
    public final double field_72450_a;
    public final double field_72448_b;
    public final double field_72449_c;

    @OnlyIn(value=Dist.CLIENT)
    public static Vector3d func_237487_a_(int packed) {
        double d0 = (double)(packed >> 16 & 0xFF) / 255.0;
        double d1 = (double)(packed >> 8 & 0xFF) / 255.0;
        double d2 = (double)(packed & 0xFF) / 255.0;
        return new Vector3d(d0, d1, d2);
    }

    public static Vector3d func_237489_a_(Vector3i toCopy) {
        return new Vector3d((double)toCopy.func_177958_n() + 0.5, (double)toCopy.func_177956_o() + 0.5, (double)toCopy.func_177952_p() + 0.5);
    }

    public static Vector3d func_237491_b_(Vector3i toCopy) {
        return new Vector3d(toCopy.func_177958_n(), toCopy.func_177956_o(), toCopy.func_177952_p());
    }

    public static Vector3d func_237492_c_(Vector3i toCopy) {
        return new Vector3d((double)toCopy.func_177958_n() + 0.5, toCopy.func_177956_o(), (double)toCopy.func_177952_p() + 0.5);
    }

    public static Vector3d func_237490_a_(Vector3i toCopy, double verticalOffset) {
        return new Vector3d((double)toCopy.func_177958_n() + 0.5, (double)toCopy.func_177956_o() + verticalOffset, (double)toCopy.func_177952_p() + 0.5);
    }

    public Vector3d(double xIn, double yIn, double zIn) {
        this.field_72450_a = xIn;
        this.field_72448_b = yIn;
        this.field_72449_c = zIn;
    }

    public Vector3d(Vector3f vec) {
        this(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c());
    }

    public Vector3d func_72444_a(Vector3d vec) {
        return new Vector3d(vec.field_72450_a - this.field_72450_a, vec.field_72448_b - this.field_72448_b, vec.field_72449_c - this.field_72449_c);
    }

    public Vector3d func_72432_b() {
        double d0 = MathHelper.func_76133_a((double)(this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c));
        return d0 < 1.0E-4 ? field_186680_a : new Vector3d(this.field_72450_a / d0, this.field_72448_b / d0, this.field_72449_c / d0);
    }

    public double func_72430_b(Vector3d vec) {
        return this.field_72450_a * vec.field_72450_a + this.field_72448_b * vec.field_72448_b + this.field_72449_c * vec.field_72449_c;
    }

    public Vector3d func_72431_c(Vector3d vec) {
        return new Vector3d(this.field_72448_b * vec.field_72449_c - this.field_72449_c * vec.field_72448_b, this.field_72449_c * vec.field_72450_a - this.field_72450_a * vec.field_72449_c, this.field_72450_a * vec.field_72448_b - this.field_72448_b * vec.field_72450_a);
    }

    public Vector3d func_178788_d(Vector3d vec) {
        return this.func_178786_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3d func_178786_a(double x, double y, double z) {
        return this.func_72441_c(-x, -y, -z);
    }

    public Vector3d func_178787_e(Vector3d vec) {
        return this.func_72441_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3d func_72441_c(double x, double y, double z) {
        return new Vector3d(this.field_72450_a + x, this.field_72448_b + y, this.field_72449_c + z);
    }

    public boolean func_237488_a_(IPosition pos, double distance) {
        return this.func_186679_c(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c()) < distance * distance;
    }

    public double func_72438_d(Vector3d vec) {
        double d0 = vec.field_72450_a - this.field_72450_a;
        double d1 = vec.field_72448_b - this.field_72448_b;
        double d2 = vec.field_72449_c - this.field_72449_c;
        return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
    }

    public double func_72436_e(Vector3d vec) {
        double d0 = vec.field_72450_a - this.field_72450_a;
        double d1 = vec.field_72448_b - this.field_72448_b;
        double d2 = vec.field_72449_c - this.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_186679_c(double xIn, double yIn, double zIn) {
        double d0 = xIn - this.field_72450_a;
        double d1 = yIn - this.field_72448_b;
        double d2 = zIn - this.field_72449_c;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vector3d func_186678_a(double factor) {
        return this.func_216372_d(factor, factor, factor);
    }

    public Vector3d func_216371_e() {
        return this.func_186678_a(-1.0);
    }

    public Vector3d func_216369_h(Vector3d vec) {
        return this.func_216372_d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3d func_216372_d(double factorX, double factorY, double factorZ) {
        return new Vector3d(this.field_72450_a * factorX, this.field_72448_b * factorY, this.field_72449_c * factorZ);
    }

    public double func_72433_c() {
        return MathHelper.func_76133_a((double)(this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c));
    }

    public double func_189985_c() {
        return this.field_72450_a * this.field_72450_a + this.field_72448_b * this.field_72448_b + this.field_72449_c * this.field_72449_c;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vector3d)) {
            return false;
        }
        Vector3d vector3d = (Vector3d)p_equals_1_;
        if (Double.compare(vector3d.field_72450_a, this.field_72450_a) != 0) {
            return false;
        }
        if (Double.compare(vector3d.field_72448_b, this.field_72448_b) != 0) {
            return false;
        }
        return Double.compare(vector3d.field_72449_c, this.field_72449_c) == 0;
    }

    public int hashCode() {
        long j = Double.doubleToLongBits(this.field_72450_a);
        int i = (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.field_72448_b);
        i = 31 * i + (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.field_72449_c);
        return 31 * i + (int)(j ^ j >>> 32);
    }

    public String toString() {
        return "(" + this.field_72450_a + ", " + this.field_72448_b + ", " + this.field_72449_c + ")";
    }

    public Vector3d func_178789_a(float pitch) {
        float f = MathHelper.func_76134_b((float)pitch);
        float f1 = MathHelper.func_76126_a((float)pitch);
        double d0 = this.field_72450_a;
        double d1 = this.field_72448_b * (double)f + this.field_72449_c * (double)f1;
        double d2 = this.field_72449_c * (double)f - this.field_72448_b * (double)f1;
        return new Vector3d(d0, d1, d2);
    }

    public Vector3d func_178785_b(float yaw) {
        float f = MathHelper.func_76134_b((float)yaw);
        float f1 = MathHelper.func_76126_a((float)yaw);
        double d0 = this.field_72450_a * (double)f + this.field_72449_c * (double)f1;
        double d1 = this.field_72448_b;
        double d2 = this.field_72449_c * (double)f - this.field_72450_a * (double)f1;
        return new Vector3d(d0, d1, d2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_242988_c(float roll) {
        float f = MathHelper.func_76134_b((float)roll);
        float f1 = MathHelper.func_76126_a((float)roll);
        double d0 = this.field_72450_a * (double)f + this.field_72448_b * (double)f1;
        double d1 = this.field_72448_b * (double)f - this.field_72450_a * (double)f1;
        double d2 = this.field_72449_c;
        return new Vector3d(d0, d1, d2);
    }

    public static Vector3d func_189984_a(Vector2f vec) {
        return Vector3d.func_189986_a(vec.field_189982_i, vec.field_189983_j);
    }

    public static Vector3d func_189986_a(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vector3d(f1 * f2, f3, f * f2);
    }

    public Vector3d func_197746_a(EnumSet<Direction.Axis> axes) {
        double d0 = axes.contains(Direction.Axis.X) ? (double)MathHelper.func_76128_c((double)this.field_72450_a) : this.field_72450_a;
        double d1 = axes.contains(Direction.Axis.Y) ? (double)MathHelper.func_76128_c((double)this.field_72448_b) : this.field_72448_b;
        double d2 = axes.contains(Direction.Axis.Z) ? (double)MathHelper.func_76128_c((double)this.field_72449_c) : this.field_72449_c;
        return new Vector3d(d0, d1, d2);
    }

    public double func_216370_a(Direction.Axis axis) {
        return axis.func_196051_a(this.field_72450_a, this.field_72448_b, this.field_72449_c);
    }

    public final double func_82615_a() {
        return this.field_72450_a;
    }

    public final double func_82617_b() {
        return this.field_72448_b;
    }

    public final double func_82616_c() {
        return this.field_72449_c;
    }
}

