/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessRecipe
implements ICraftingRecipe {
    private final ResourceLocation field_199562_a;
    private final String field_194138_c;
    private final ItemStack field_77580_a;
    private final NonNullList<Ingredient> field_77579_b;
    private final boolean isSimple;

    public ShapelessRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        this.field_199562_a = idIn;
        this.field_194138_c = groupIn;
        this.field_77580_a = recipeOutputIn;
        this.field_77579_b = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
    }

    public ResourceLocation func_199560_c() {
        return this.field_199562_a;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return IRecipeSerializer.field_222158_b;
    }

    public String func_193358_e() {
        return this.field_194138_c;
    }

    public ItemStack func_77571_b() {
        return this.field_77580_a;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77579_b;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.field_77579_b.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)((Object)this), (IntList)null) : RecipeMatcher.findMatches(inputs, this.field_77579_b) != null);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.field_77580_a.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.field_77579_b.size();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapelessRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");

        @Override
        public ShapelessRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.func_199568_a(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is " + ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.func_199798_a(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapelessRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> func_199568_a(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a(ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Override
        public ShapelessRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b(buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapelessRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        @Override
        public void func_199427_a_(PacketBuffer buffer, ShapelessRecipe recipe) {
            buffer.func_180714_a(recipe.field_194138_c);
            buffer.func_150787_b(recipe.field_77579_b.size());
            for (Ingredient ingredient : recipe.field_77579_b) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.field_77580_a);
        }
    }
}

