/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ProjectileHelper {
    public static RayTraceResult func_234618_a_(Entity p_234618_0_, Predicate<Entity> p_234618_1_) {
        EntityRayTraceResult raytraceresult1;
        Vector3d vector3d2;
        Vector3d vector3d = p_234618_0_.func_213322_ci();
        World world = p_234618_0_.field_70170_p;
        Vector3d vector3d1 = p_234618_0_.func_213303_ch();
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(vector3d1, vector3d2 = vector3d1.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, p_234618_0_));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d2 = raytraceresult.func_216347_e();
        }
        if ((raytraceresult1 = ProjectileHelper.func_221269_a(world, p_234618_0_, vector3d1, vector3d2, p_234618_0_.func_174813_aQ().func_216361_a(p_234618_0_.func_213322_ci()).func_186662_g(1.0), p_234618_1_)) != null) {
            raytraceresult = raytraceresult1;
        }
        return raytraceresult;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRayTraceResult func_221273_a(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }

    @Nullable
    public static EntityRayTraceResult func_221269_a(World worldIn, Entity projectile, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.func_175674_a(projectile, boundingBox, filter)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e((Vector3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    public static final void func_188803_a(Entity projectile, float rotationSpeed) {
        Vector3d vector3d = projectile.func_213322_ci();
        if (vector3d.func_189985_c() != 0.0) {
            float f = MathHelper.func_76133_a((double)Entity.func_213296_b(vector3d));
            projectile.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875) + 90.0f;
            projectile.field_70125_A = (float)(MathHelper.func_181159_b((double)f, (double)vector3d.field_72448_b) * 57.2957763671875) - 90.0f;
            while (projectile.field_70125_A - projectile.field_70127_C < -180.0f) {
                projectile.field_70127_C -= 360.0f;
            }
            while (projectile.field_70125_A - projectile.field_70127_C >= 180.0f) {
                projectile.field_70127_C += 360.0f;
            }
            while (projectile.field_70177_z - projectile.field_70126_B < -180.0f) {
                projectile.field_70126_B -= 360.0f;
            }
            while (projectile.field_70177_z - projectile.field_70126_B >= 180.0f) {
                projectile.field_70126_B += 360.0f;
            }
            projectile.field_70125_A = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70127_C, (float)projectile.field_70125_A);
            projectile.field_70177_z = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70126_B, (float)projectile.field_70177_z);
        }
    }

    public static Hand func_221274_a(LivingEntity living, Item itemIn) {
        return living.func_184614_ca().func_77973_b() == itemIn ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static AbstractArrowEntity func_221272_a(LivingEntity shooter, ItemStack arrowStack, float distanceFactor) {
        ArrowItem arrowitem = (ArrowItem)(arrowStack.func_77973_b() instanceof ArrowItem ? arrowStack.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(shooter.field_70170_p, arrowStack, shooter);
        abstractarrowentity.func_190547_a(shooter, distanceFactor);
        if (arrowStack.func_77973_b() == Items.field_185167_i && abstractarrowentity instanceof ArrowEntity) {
            ((ArrowEntity)abstractarrowentity).func_184555_a(arrowStack);
        }
        return abstractarrowentity;
    }
}

