/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HoglinEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.util.TriPredicate;

public class EntitySpawnPlacementRegistry {
    private static final Map<EntityType<?>, Entry> field_209347_a = Maps.newHashMap();

    public static <T extends MobEntity> void func_209343_a(EntityType<T> entityTypeIn, PlacementType placementType, Heightmap.Type heightMapType, IPlacementPredicate<T> placementPredicate) {
        Entry entityspawnplacementregistry$entry = field_209347_a.put(entityTypeIn, new Entry(heightMapType, placementType, placementPredicate));
        if (entityspawnplacementregistry$entry != null) {
            throw new IllegalStateException("Duplicate registration for type " + Registry.field_212629_r.func_177774_c(entityTypeIn));
        }
    }

    public static PlacementType func_209344_a(EntityType<?> entityTypeIn) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(entityTypeIn);
        return entityspawnplacementregistry$entry == null ? PlacementType.NO_RESTRICTIONS : entityspawnplacementregistry$entry.field_209340_b;
    }

    public static Heightmap.Type func_209342_b(@Nullable EntityType<?> entityTypeIn) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(entityTypeIn);
        return entityspawnplacementregistry$entry == null ? Heightmap.Type.MOTION_BLOCKING_NO_LEAVES : entityspawnplacementregistry$entry.field_209339_a;
    }

    public static <T extends Entity> boolean func_223515_a(EntityType<T> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Entry entityspawnplacementregistry$entry = field_209347_a.get(entityType);
        return entityspawnplacementregistry$entry == null || entityspawnplacementregistry$entry.field_223513_c.test(entityType, world, reason, pos, rand);
    }

    static {
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203780_j, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_205137_n, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DolphinEntity::func_223364_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_204724_o, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DrownedEntity::func_223332_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200761_A, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GuardianEntity::func_223329_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203779_Z, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203778_ae, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200749_ao, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SquidEntity::func_223365_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_204262_at, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AbstractFishEntity::func_223363_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200791_e, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BatEntity::func_223369_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200792_f, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200794_h, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200795_i, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200796_j, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200797_k, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200798_l, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200803_q, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200804_r, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndermiteEntity::func_223328_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200802_p, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200811_y, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GhastEntity::func_223368_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200812_z, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200762_B, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200763_C, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HuskEntity::func_223334_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200757_aw, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200769_I, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200771_K, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MagmaCubeEntity::func_223367_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200780_T, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MooshroomEntity::func_223318_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200779_S, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200781_U, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, OcelotEntity::func_223319_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200783_W, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING, ParrotEntity::func_223317_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200784_X, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_233588_G_, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, HoglinEntity::func_234361_c_);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_233591_ai_, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PiglinEntity::func_234418_b_);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220350_aJ, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PatrollerEntity::func_223330_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200786_Z, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, PolarBearEntity::func_223320_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200736_ab, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, RabbitEntity::func_223321_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200737_ac, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200740_af, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SilverfishEntity::func_223331_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200741_ag, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200742_ah, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200743_ai, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SlimeEntity::func_223366_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200745_ak, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200748_an, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200750_ap, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StrayEntity::func_223327_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_233589_aE_, PlacementType.IN_LAVA, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StriderEntity::func_234314_c_);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203099_aq, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, TurtleEntity::func_223322_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200756_av, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200759_ay, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200760_az, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200722_aA, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200724_aC, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200725_aD, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200726_aE, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_233592_ba_, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ZombifiedPiglinEntity::func_234351_b_);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200727_aF, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220360_g, PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200800_n, PlacementType.IN_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GuardianEntity::func_223329_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200806_t, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220356_B, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200764_D, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220353_aa, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_203097_aH, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220352_aU, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200738_ad, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220354_ax, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AnimalEntity::func_223316_b);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200755_au, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_200758_ax, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(EntityType.field_220351_aK, PlacementType.NO_RESTRICTIONS, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    public static enum PlacementType implements IExtensibleEnum
    {
        ON_GROUND,
        IN_WATER,
        NO_RESTRICTIONS,
        IN_LAVA;

        private TriPredicate<IWorldReader, BlockPos, EntityType<?>> predicate;

        public static PlacementType create(String name, TriPredicate<IWorldReader, BlockPos, EntityType<? extends MobEntity>> predicate) {
            throw new IllegalStateException("Enum not extended");
        }

        private PlacementType() {
            this(null);
        }

        private PlacementType(TriPredicate<IWorldReader, BlockPos, EntityType<?>> predicate) {
            this.predicate = predicate;
        }

        public boolean canSpawnAt(IWorldReader world, BlockPos pos, EntityType<?> type) {
            if (this == NO_RESTRICTIONS) {
                return true;
            }
            if (this.predicate == null) {
                return WorldEntitySpawner.canSpawnAtBody(this, world, pos, type);
            }
            return this.predicate.test((Object)world, (Object)pos, type);
        }
    }

    @FunctionalInterface
    public static interface IPlacementPredicate<T extends Entity> {
        public boolean test(EntityType<T> var1, IServerWorld var2, SpawnReason var3, BlockPos var4, Random var5);
    }

    static class Entry {
        private final Heightmap.Type field_209339_a;
        private final PlacementType field_209340_b;
        private final IPlacementPredicate<?> field_223513_c;

        public Entry(Heightmap.Type typeIn, PlacementType placementTypeIn, IPlacementPredicate<?> placementPredicateIn) {
            this.field_209339_a = typeIn;
            this.field_209340_b = placementTypeIn;
            this.field_223513_c = placementPredicateIn;
        }
    }
}

