/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.vertex;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.IntConsumer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class VertexFormatElement {
    private static final Logger field_177381_a = LogManager.getLogger();
    private final Type field_177379_b;
    private final Usage field_177380_c;
    private final int field_177377_d;
    private final int field_177378_e;
    private final int field_227896_f_;

    public VertexFormatElement(int indexIn, Type typeIn, Usage usageIn, int count) {
        if (this.func_177372_a(indexIn, usageIn)) {
            this.field_177380_c = usageIn;
        } else {
            field_177381_a.warn("Multiple vertex elements of the same type other than UVs are not supported. Forcing type to UV.");
            this.field_177380_c = Usage.UV;
        }
        this.field_177379_b = typeIn;
        this.field_177377_d = indexIn;
        this.field_177378_e = count;
        this.field_227896_f_ = typeIn.func_177395_a() * this.field_177378_e;
    }

    private boolean func_177372_a(int indexIn, Usage usageIn) {
        return indexIn == 0 || usageIn == Usage.UV;
    }

    public final Type func_177367_b() {
        return this.field_177379_b;
    }

    public final Usage func_177375_c() {
        return this.field_177380_c;
    }

    public final int func_177369_e() {
        return this.field_177377_d;
    }

    public String toString() {
        return this.field_177378_e + "," + this.field_177380_c.func_177384_a() + "," + this.field_177379_b.func_177396_b();
    }

    public final int func_177368_f() {
        return this.field_227896_f_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            VertexFormatElement vertexformatelement = (VertexFormatElement)p_equals_1_;
            if (this.field_177378_e != vertexformatelement.field_177378_e) {
                return false;
            }
            if (this.field_177377_d != vertexformatelement.field_177377_d) {
                return false;
            }
            if (this.field_177379_b != vertexformatelement.field_177379_b) {
                return false;
            }
            return this.field_177380_c == vertexformatelement.field_177380_c;
        }
        return false;
    }

    public int hashCode() {
        int i = this.field_177379_b.hashCode();
        i = 31 * i + this.field_177380_c.hashCode();
        i = 31 * i + this.field_177377_d;
        return 31 * i + this.field_177378_e;
    }

    public void func_227897_a_(long pointerIn, int strideIn) {
        this.field_177380_c.func_227902_a_(this.field_177378_e, this.field_177379_b.func_177397_c(), strideIn, pointerIn, this.field_177377_d);
    }

    public void func_227898_g_() {
        this.field_177380_c.func_227901_a_(this.field_177377_d);
    }

    public int getElementCount() {
        return this.field_177378_e;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Usage {
        POSITION("Position", (p_227914_0_, p_227914_1_, p_227914_2_, p_227914_3_, p_227914_5_) -> {
            GlStateManager.func_227679_b_(p_227914_0_, p_227914_1_, p_227914_2_, p_227914_3_);
            GlStateManager.func_227770_y_(32884);
        }, p_227912_0_ -> GlStateManager.func_227772_z_(32884)),
        NORMAL("Normal", (p_227913_0_, p_227913_1_, p_227913_2_, p_227913_3_, p_227913_5_) -> {
            GlStateManager.func_227652_a_(p_227913_1_, p_227913_2_, p_227913_3_);
            GlStateManager.func_227770_y_(32885);
        }, p_227910_0_ -> GlStateManager.func_227772_z_(32885)),
        COLOR("Vertex Color", (p_227911_0_, p_227911_1_, p_227911_2_, p_227911_3_, p_227911_5_) -> {
            GlStateManager.func_227694_c_(p_227911_0_, p_227911_1_, p_227911_2_, p_227911_3_);
            GlStateManager.func_227770_y_(32886);
        }, p_227908_0_ -> {
            GlStateManager.func_227772_z_(32886);
            GlStateManager.func_227628_P_();
        }),
        UV("UV", (p_227909_0_, p_227909_1_, p_227909_2_, p_227909_3_, p_227909_5_) -> {
            GlStateManager.func_227747_o_(33984 + p_227909_5_);
            GlStateManager.func_227650_a_(p_227909_0_, p_227909_1_, p_227909_2_, p_227909_3_);
            GlStateManager.func_227770_y_(32888);
            GlStateManager.func_227747_o_(33984);
        }, p_227906_0_ -> {
            GlStateManager.func_227747_o_(33984 + p_227906_0_);
            GlStateManager.func_227772_z_(32888);
            GlStateManager.func_227747_o_(33984);
        }),
        PADDING("Padding", (p_227907_0_, p_227907_1_, p_227907_2_, p_227907_3_, p_227907_5_) -> {}, p_227904_0_ -> {}),
        GENERIC("Generic", (p_227905_0_, p_227905_1_, p_227905_2_, p_227905_3_, p_227905_5_) -> {
            GlStateManager.func_227606_A_(p_227905_5_);
            GlStateManager.func_227651_a_(p_227905_5_, p_227905_0_, p_227905_1_, false, p_227905_2_, p_227905_3_);
        }, GlStateManager::func_227608_B_);

        private final String field_177392_h;
        private final ISetupState field_227899_h_;
        private final IntConsumer field_227900_i_;

        private Usage(String displayNameIn, ISetupState setupStateIn, IntConsumer clearStateIn) {
            this.field_177392_h = displayNameIn;
            this.field_227899_h_ = setupStateIn;
            this.field_227900_i_ = clearStateIn;
        }

        private void func_227902_a_(int countIn, int glTypeIn, int strideIn, long pointerIn, int indexIn) {
            this.field_227899_h_.setupBufferState(countIn, glTypeIn, strideIn, pointerIn, indexIn);
        }

        public void func_227901_a_(int indexIn) {
            this.field_227900_i_.accept(indexIn);
        }

        public String func_177384_a() {
            return this.field_177392_h;
        }

        @OnlyIn(value=Dist.CLIENT)
        static interface ISetupState {
            public void setupBufferState(int var1, int var2, int var3, long var4, int var6);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        FLOAT(4, "Float", 5126),
        UBYTE(1, "Unsigned Byte", 5121),
        BYTE(1, "Byte", 5120),
        USHORT(2, "Unsigned Short", 5123),
        SHORT(2, "Short", 5122),
        UINT(4, "Unsigned Int", 5125),
        INT(4, "Int", 5124);

        private final int field_177407_h;
        private final String field_177408_i;
        private final int field_177405_j;

        private Type(int sizeIn, String displayNameIn, int glConstantIn) {
            this.field_177407_h = sizeIn;
            this.field_177408_i = displayNameIn;
            this.field_177405_j = glConstantIn;
        }

        public int func_177395_a() {
            return this.field_177407_h;
        }

        public String func_177396_b() {
            return this.field_177408_i;
        }

        public int func_177397_c() {
            return this.field_177405_j;
        }
    }
}

