/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TrapDoorBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty field_176283_b = BlockStateProperties.field_208193_t;
    public static final EnumProperty<Half> field_176285_M = BlockStateProperties.field_208164_Q;
    public static final BooleanProperty field_196381_c = BlockStateProperties.field_208194_u;
    public static final BooleanProperty field_204614_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185734_d = Block.func_208617_a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape field_185735_e = Block.func_208617_a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185736_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape field_185737_g = Block.func_208617_a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185732_B = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape field_185733_C = Block.func_208617_a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);

    public TrapDoorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)((Object)Direction.NORTH)))).func_206870_a((Property)field_176283_b, Boolean.valueOf(false)))).func_206870_a((Property)field_176285_M, (Comparable)Half.BOTTOM))).func_206870_a((Property)field_196381_c, Boolean.valueOf(false)))).func_206870_a((Property)field_204614_t, Boolean.valueOf(false))));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!((Boolean)state.func_177229_b((Property)field_176283_b)).booleanValue()) {
            return state.func_177229_b((Property)field_176285_M) == Half.TOP ? field_185733_C : field_185732_B;
        }
        switch ((Direction)((Object)state.func_177229_b((Property)field_185512_D))) {
            default: {
                return field_185737_g;
            }
            case SOUTH: {
                return field_185736_f;
            }
            case WEST: {
                return field_185735_e;
            }
            case EAST: 
        }
        return field_185734_d;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((Property)field_176283_b);
            }
            case WATER: {
                return (Boolean)state.func_177229_b((Property)field_204614_t);
            }
            case AIR: {
                return (Boolean)state.func_177229_b((Property)field_176283_b);
            }
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.field_149764_J == Material.field_151573_f) {
            return ActionResultType.PASS;
        }
        state = (BlockState)((Object)state.func_235896_a_((Property)field_176283_b));
        worldIn.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((Property)field_204614_t)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)((Object)worldIn)));
        }
        this.func_185731_a(player, worldIn, pos, (Boolean)state.func_177229_b((Property)field_176283_b));
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    protected void func_185731_a(@Nullable PlayerEntity player, World worldIn, BlockPos pos, boolean isOpened) {
        if (isOpened) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_217378_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_217378_a(player, j, pos, 0);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)field_196381_c)) {
            if ((Boolean)state.func_177229_b((Property)field_176283_b) != flag) {
                state = (BlockState)((Object)state.func_206870_a((Property)field_176283_b, Boolean.valueOf(flag)));
                this.func_185731_a(null, worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((Property)field_196381_c, Boolean.valueOf(flag))), 2);
            if (((Boolean)state.func_177229_b((Property)field_204614_t)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)((Object)worldIn)));
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        Direction direction = context.func_196000_l();
        blockstate = !context.func_196012_c() && direction.func_176740_k().func_176722_c() ? (BlockState)((Object)((BlockState)((Object)blockstate.func_206870_a((Property)field_185512_D, (Comparable)((Object)direction)))).func_206870_a((Property)field_176285_M, (Comparable)(context.func_221532_j().field_72448_b - (double)context.func_195995_a().func_177956_o() > 0.5 ? Half.TOP : Half.BOTTOM))) : (BlockState)((Object)((BlockState)((Object)blockstate.func_206870_a((Property)field_185512_D, (Comparable)((Object)context.func_195992_f().func_176734_d())))).func_206870_a((Property)field_176285_M, (Comparable)(direction == Direction.UP ? Half.BOTTOM : Half.TOP)));
        if (context.func_195991_k().func_175640_z(context.func_195995_a())) {
            blockstate = (BlockState)((Object)((BlockState)((Object)blockstate.func_206870_a((Property)field_176283_b, Boolean.valueOf(true)))).func_206870_a((Property)field_196381_c, Boolean.valueOf(true)));
        }
        return (BlockState)((Object)blockstate.func_206870_a((Property)field_204614_t, Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, field_176283_b, field_176285_M, field_196381_c, field_204614_t});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)field_204614_t) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)field_204614_t)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        BlockState down;
        if (((Boolean)state.func_177229_b((Property)field_176283_b)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap) {
            return down.func_177229_b((Property)LadderBlock.field_176382_a) == state.func_177229_b((Property)field_185512_D);
        }
        return false;
    }
}

