/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.EntitySize;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class PortalSize {
    private static final AbstractBlock.IPositionPredicate field_242962_a = (p_242966_0_, p_242966_1_, p_242966_2_) -> p_242966_0_.isPortalFrame(p_242966_1_, p_242966_2_);
    private final IWorld field_150867_a;
    private final Direction.Axis field_150865_b;
    private final Direction field_150866_c;
    private int field_150864_e;
    @Nullable
    private BlockPos field_150861_f;
    private int field_150862_g;
    private int field_150868_h;

    public static Optional<PortalSize> func_242964_a(IWorld world, BlockPos pos, Direction.Axis axis) {
        return PortalSize.func_242965_a(world, pos, p_242968_0_ -> p_242968_0_.func_150860_b() && p_242968_0_.field_150864_e == 0, axis);
    }

    public static Optional<PortalSize> func_242965_a(IWorld world, BlockPos pos, Predicate<PortalSize> sizePredicate, Direction.Axis axis) {
        Optional<PortalSize> optional = Optional.of(new PortalSize(world, pos, axis)).filter(sizePredicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new PortalSize(world, pos, direction$axis)).filter(sizePredicate);
    }

    public PortalSize(IWorld worldIn, BlockPos pos, Direction.Axis axisIn) {
        this.field_150867_a = worldIn;
        this.field_150865_b = axisIn;
        this.field_150866_c = axisIn == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.field_150861_f = this.func_242971_a(pos);
        if (this.field_150861_f == null) {
            this.field_150861_f = pos;
            this.field_150868_h = 1;
            this.field_150862_g = 1;
        } else {
            this.field_150868_h = this.func_242974_d();
            if (this.field_150868_h > 0) {
                this.field_150862_g = this.func_242975_e();
            }
        }
    }

    @Nullable
    private BlockPos func_242971_a(BlockPos pos) {
        int i = Math.max(0, pos.func_177956_o() - 21);
        while (pos.func_177956_o() > i && PortalSize.func_196900_a(this.field_150867_a.func_180495_p(pos.func_177977_b()))) {
            pos = pos.func_177977_b();
        }
        Direction direction = this.field_150866_c.func_176734_d();
        int j = this.func_242972_a(pos, direction) - 1;
        return j < 0 ? null : pos.func_177967_a(direction, j);
    }

    private int func_242974_d() {
        int i = this.func_242972_a(this.field_150861_f, this.field_150866_c);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int func_242972_a(BlockPos pos, Direction direction) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutable.func_189533_g((Vector3i)pos).func_189534_c(direction, i);
            BlockState blockstate = this.field_150867_a.func_180495_p((BlockPos)blockpos$mutable);
            if (!PortalSize.func_196900_a(blockstate)) {
                if (!field_242962_a.test(blockstate, (IBlockReader)this.field_150867_a, (BlockPos)blockpos$mutable)) break;
                return i;
            }
            BlockState blockstate1 = this.field_150867_a.func_180495_p((BlockPos)blockpos$mutable.func_189536_c(Direction.DOWN));
            if (!field_242962_a.test(blockstate1, (IBlockReader)this.field_150867_a, (BlockPos)blockpos$mutable)) break;
        }
        return 0;
    }

    private int func_242975_e() {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = this.func_242969_a(blockpos$mutable);
        return i >= 3 && i <= 21 && this.func_242970_a(blockpos$mutable, i) ? i : 0;
    }

    private boolean func_242970_a(BlockPos.Mutable mutablePos, int upDisplacement) {
        for (int i = 0; i < this.field_150868_h; ++i) {
            BlockPos.Mutable blockpos$mutable = mutablePos.func_189533_g((Vector3i)this.field_150861_f).func_189534_c(Direction.UP, upDisplacement).func_189534_c(this.field_150866_c, i);
            if (field_242962_a.test(this.field_150867_a.func_180495_p((BlockPos)blockpos$mutable), (IBlockReader)this.field_150867_a, (BlockPos)blockpos$mutable)) continue;
            return false;
        }
        return true;
    }

    private int func_242969_a(BlockPos.Mutable mutablePos) {
        for (int i = 0; i < 21; ++i) {
            mutablePos.func_189533_g((Vector3i)this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, -1);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p((BlockPos)mutablePos), (IBlockReader)this.field_150867_a, (BlockPos)mutablePos)) {
                return i;
            }
            mutablePos.func_189533_g((Vector3i)this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, this.field_150868_h);
            if (!field_242962_a.test(this.field_150867_a.func_180495_p((BlockPos)mutablePos), (IBlockReader)this.field_150867_a, (BlockPos)mutablePos)) {
                return i;
            }
            for (int j = 0; j < this.field_150868_h; ++j) {
                mutablePos.func_189533_g((Vector3i)this.field_150861_f).func_189534_c(Direction.UP, i).func_189534_c(this.field_150866_c, j);
                BlockState blockstate = this.field_150867_a.func_180495_p((BlockPos)mutablePos);
                if (!PortalSize.func_196900_a(blockstate)) {
                    return i;
                }
                if (!blockstate.func_203425_a(Blocks.field_150427_aO)) continue;
                ++this.field_150864_e;
            }
        }
        return 21;
    }

    private static boolean func_196900_a(BlockState state) {
        return state.func_196958_f() || state.func_235714_a_(BlockTags.field_232872_am_) || state.func_203425_a(Blocks.field_150427_aO);
    }

    public boolean func_150860_b() {
        return this.field_150861_f != null && this.field_150868_h >= 2 && this.field_150868_h <= 21 && this.field_150862_g >= 3 && this.field_150862_g <= 21;
    }

    public void func_150859_c() {
        BlockState blockstate = (BlockState)((Object)Blocks.field_150427_aO.func_176223_P().func_206870_a((Property)NetherPortalBlock.field_176550_a, (Comparable)((Object)this.field_150865_b)));
        BlockPos.func_218278_a((BlockPos)this.field_150861_f, (BlockPos)this.field_150861_f.func_177967_a(Direction.UP, this.field_150862_g - 1).func_177967_a(this.field_150866_c, this.field_150868_h - 1)).forEach(p_242967_2_ -> this.field_150867_a.func_180501_a(p_242967_2_, blockstate, 18));
    }

    public boolean func_208508_f() {
        return this.func_150860_b() && this.field_150864_e == this.field_150868_h * this.field_150862_g;
    }

    public static Vector3d func_242973_a(TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d positionVector, EntitySize size) {
        double d4;
        double d2;
        double d0 = (double)result.field_243680_b - (double)size.field_220315_a;
        double d1 = (double)result.field_243681_c - (double)size.field_220316_b;
        BlockPos blockpos = result.field_243679_a;
        if (d0 > 0.0) {
            float f = (float)blockpos.func_243648_a(axis) + size.field_220315_a / 2.0f;
            d2 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(positionVector.func_216370_a(axis) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            Direction.Axis direction$axis = Direction.Axis.Y;
            d4 = MathHelper.func_151237_a((double)MathHelper.func_233020_c_((double)(positionVector.func_216370_a(direction$axis) - (double)blockpos.func_243648_a(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
        } else {
            d4 = 0.0;
        }
        Direction.Axis direction$axis1 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d3 = positionVector.func_216370_a(direction$axis1) - ((double)blockpos.func_243648_a(direction$axis1) + 0.5);
        return new Vector3d(d2, d4, d3);
    }

    public static PortalInfo func_242963_a(ServerWorld world, TeleportationRepositioner.Result result, Direction.Axis axis, Vector3d offsetVector, EntitySize size, Vector3d motion, float rotationYaw, float rotationPitch) {
        BlockPos blockpos = result.field_243679_a;
        BlockState blockstate = world.func_180495_p(blockpos);
        Direction.Axis direction$axis = (Direction.Axis)((Object)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z));
        double d0 = result.field_243680_b;
        double d1 = result.field_243681_c;
        int i = axis == direction$axis ? 0 : 90;
        Vector3d vector3d = axis == direction$axis ? motion : new Vector3d(motion.field_72449_c, motion.field_72448_b, -motion.field_72450_a);
        double d2 = (double)size.field_220315_a / 2.0 + (d0 - (double)size.field_220315_a) * offsetVector.func_82615_a();
        double d3 = (d1 - (double)size.field_220316_b) * offsetVector.func_82617_b();
        double d4 = 0.5 + offsetVector.func_82616_c();
        boolean flag = direction$axis == Direction.Axis.X;
        Vector3d vector3d1 = new Vector3d((double)blockpos.func_177958_n() + (flag ? d2 : d4), (double)blockpos.func_177956_o() + d3, (double)blockpos.func_177952_p() + (flag ? d4 : d2));
        return new PortalInfo(vector3d1, vector3d, rotationYaw + (float)i, rotationPitch);
    }
}

