/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;

public class MushroomBlock
extends BushBlock
implements IGrowable {
    protected static final VoxelShape field_196385_a = Block.func_208617_a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);

    public MushroomBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return field_196385_a;
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (random.nextInt(25) == 0) {
            int i = 5;
            int j = 4;
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (!worldIn.func_180495_p(blockpos).func_203425_a(this) || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (worldIn.func_175623_d(blockpos1) && state.func_196955_c((IWorldReader)((Object)worldIn), blockpos1)) {
                    pos = blockpos1;
                }
                blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (worldIn.func_175623_d(blockpos1) && state.func_196955_c((IWorldReader)((Object)worldIn), blockpos1)) {
                worldIn.func_180501_a(blockpos1, state, 2);
            }
        }
    }

    @Override
    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    @Override
    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_235714_a_(BlockTags.field_242171_aD)) {
            return true;
        }
        return worldIn.func_226659_b_(pos, 0) < 13 && blockstate.canSustainPlant((IBlockReader)((Object)worldIn), blockpos, Direction.UP, this);
    }

    public boolean func_226940_a_(ServerWorld world, BlockPos pos, BlockState state, Random rand) {
        ConfiguredFeature configuredfeature;
        world.func_217377_a(pos, false);
        if (this == Blocks.field_150338_P) {
            configuredfeature = Features.field_243860_bF;
        } else {
            if (this != Blocks.field_150337_Q) {
                world.func_180501_a(pos, state, 3);
                return false;
            }
            configuredfeature = Features.field_243861_bG;
        }
        if (configuredfeature.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), rand, pos)) {
            return true;
        }
        world.func_180501_a(pos, state, 3);
        return false;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return (double)rand.nextFloat() < 0.4;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        this.func_226940_a_(worldIn, pos, state, rand);
    }
}

