/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeGenerationSettings {
    public static final Logger field_242479_a = LogManager.getLogger();
    public static final BiomeGenerationSettings field_242480_b = new BiomeGenerationSettings(() -> ConfiguredSurfaceBuilders.field_244184_p, (Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>>)ImmutableMap.of(), (List<List<Supplier<ConfiguredFeature<?, ?>>>>)ImmutableList.of(), (List<Supplier<StructureFeature<?, ?>>>)ImmutableList.of());
    public static final MapCodec<BiomeGenerationSettings> field_242481_c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ConfiguredSurfaceBuilder.field_244393_b_.fieldOf("surface_builder").forGetter(biomeGenerationSettings -> biomeGenerationSettings.field_242482_d), (App)Codec.simpleMap(GenerationStage.Carving.field_236074_c_, (Codec)ConfiguredCarver.field_242759_c.promotePartial(Util.func_240982_a_("Carver: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_(GenerationStage.Carving.values())).fieldOf("carvers").forGetter(biomeGenerationSettings -> biomeGenerationSettings.field_242483_e), (App)ConfiguredFeature.field_242764_c.promotePartial(Util.func_240982_a_("Feature: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))).listOf().fieldOf("features").forGetter(biomeGenerationSettings -> biomeGenerationSettings.field_242484_f), (App)StructureFeature.field_242770_c.promotePartial(Util.func_240982_a_("Structure start: ", arg_0 -> ((Logger)field_242479_a).error(arg_0))).fieldOf("starts").forGetter(biomeGenerationSettings -> biomeGenerationSettings.field_242485_g)).apply((Applicative)instance, BiomeGenerationSettings::new));
    private final Supplier<ConfiguredSurfaceBuilder<?>> field_242482_d;
    private final Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> field_242483_e;
    private final List<List<Supplier<ConfiguredFeature<?, ?>>>> field_242484_f;
    private final List<Supplier<StructureFeature<?, ?>>> field_242485_g;
    private final List<ConfiguredFeature<?, ?>> field_242486_h;

    private BiomeGenerationSettings(Supplier<ConfiguredSurfaceBuilder<?>> supplier, Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> map, List<List<Supplier<ConfiguredFeature<?, ?>>>> list, List<Supplier<StructureFeature<?, ?>>> list2) {
        this.field_242482_d = supplier;
        this.field_242483_e = map;
        this.field_242484_f = list;
        this.field_242485_g = list2;
        this.field_242486_h = (List)list.stream().flatMap(Collection::stream).map(Supplier::get).flatMap(ConfiguredFeature::func_242768_d).filter(configuredFeature -> configuredFeature.field_222737_a == Feature.field_227247_y_).collect(ImmutableList.toImmutableList());
    }

    public List<Supplier<ConfiguredCarver<?>>> func_242489_a(GenerationStage.Carving carving) {
        return (List)this.field_242483_e.getOrDefault(carving, (List<Supplier<ConfiguredCarver<?>>>)ImmutableList.of());
    }

    public boolean func_242493_a(Structure<?> structure) {
        return this.field_242485_g.stream().anyMatch(supplier -> ((StructureFeature)supplier.get()).field_236268_b_ == structure);
    }

    public Collection<Supplier<StructureFeature<?, ?>>> func_242487_a() {
        return this.field_242485_g;
    }

    public StructureFeature<?, ?> func_242491_a(StructureFeature<?, ?> structureFeature) {
        return (StructureFeature)DataFixUtils.orElse(this.field_242485_g.stream().map(Supplier::get).filter(structureFeature2 -> structureFeature2.field_236268_b_ == structureFeature.field_236268_b_).findAny(), structureFeature);
    }

    public List<ConfiguredFeature<?, ?>> func_242496_b() {
        return this.field_242486_h;
    }

    public List<List<Supplier<ConfiguredFeature<?, ?>>>> func_242498_c() {
        return this.field_242484_f;
    }

    public Supplier<ConfiguredSurfaceBuilder<?>> func_242500_d() {
        return this.field_242482_d;
    }

    public ISurfaceBuilderConfig func_242502_e() {
        return this.field_242482_d.get().func_215452_a();
    }

    public static class Builder {
        private Optional<Supplier<ConfiguredSurfaceBuilder<?>>> field_242504_a = Optional.empty();
        private final Map<GenerationStage.Carving, List<Supplier<ConfiguredCarver<?>>>> field_242505_b = Maps.newLinkedHashMap();
        private final List<List<Supplier<ConfiguredFeature<?, ?>>>> field_242506_c = Lists.newArrayList();
        private final List<Supplier<StructureFeature<?, ?>>> field_242507_d = Lists.newArrayList();

        public Builder func_242517_a(ConfiguredSurfaceBuilder<?> configuredSurfaceBuilder) {
            return this.func_242519_a(() -> configuredSurfaceBuilder);
        }

        public Builder func_242519_a(Supplier<ConfiguredSurfaceBuilder<?>> supplier) {
            this.field_242504_a = Optional.of(supplier);
            return this;
        }

        public Builder func_242513_a(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> configuredFeature) {
            return this.func_242510_a(decoration.ordinal(), () -> configuredFeature);
        }

        public Builder func_242510_a(int n, Supplier<ConfiguredFeature<?, ?>> supplier) {
            this.func_242509_a(n);
            this.field_242506_c.get(n).add(supplier);
            return this;
        }

        public <C extends ICarverConfig> Builder func_242512_a(GenerationStage.Carving carving2, ConfiguredCarver<C> configuredCarver) {
            this.field_242505_b.computeIfAbsent(carving2, carving -> Lists.newArrayList()).add(() -> configuredCarver);
            return this;
        }

        public Builder func_242516_a(StructureFeature<?, ?> structureFeature) {
            this.field_242507_d.add(() -> structureFeature);
            return this;
        }

        private void func_242509_a(int n) {
            while (this.field_242506_c.size() <= n) {
                this.field_242506_c.add(Lists.newArrayList());
            }
        }

        public BiomeGenerationSettings func_242508_a() {
            return new BiomeGenerationSettings(this.field_242504_a.orElseThrow(() -> new IllegalStateException("Missing surface builder")), (Map)this.field_242505_b.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableList.copyOf((Collection)((Collection)entry.getValue())))), (List)this.field_242506_c.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList()), (List)ImmutableList.copyOf(this.field_242507_d));
        }
    }
}

