/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import net.minecraft.util.math.vector.Vector3f;

public final class Quaternion {
    public static final Quaternion field_227060_a_ = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    private float field_227061_b_;
    private float field_227062_c_;
    private float field_227063_d_;
    private float field_227064_e_;

    public Quaternion(float f, float f2, float f3, float f4) {
        this.field_227061_b_ = f;
        this.field_227062_c_ = f2;
        this.field_227063_d_ = f3;
        this.field_227064_e_ = f4;
    }

    public Quaternion(Vector3f vector3f, float f, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
        }
        float f2 = Quaternion.func_214903_b(f / 2.0f);
        this.field_227061_b_ = vector3f.func_195899_a() * f2;
        this.field_227062_c_ = vector3f.func_195900_b() * f2;
        this.field_227063_d_ = vector3f.func_195902_c() * f2;
        this.field_227064_e_ = Quaternion.func_214904_a(f / 2.0f);
    }

    public Quaternion(Quaternion quaternion) {
        this.field_227061_b_ = quaternion.field_227061_b_;
        this.field_227062_c_ = quaternion.field_227062_c_;
        this.field_227063_d_ = quaternion.field_227063_d_;
        this.field_227064_e_ = quaternion.field_227064_e_;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        if (Float.compare(quaternion.field_227061_b_, this.field_227061_b_) != 0) {
            return false;
        }
        if (Float.compare(quaternion.field_227062_c_, this.field_227062_c_) != 0) {
            return false;
        }
        if (Float.compare(quaternion.field_227063_d_, this.field_227063_d_) != 0) {
            return false;
        }
        return Float.compare(quaternion.field_227064_e_, this.field_227064_e_) == 0;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.field_227061_b_);
        n = 31 * n + Float.floatToIntBits(this.field_227062_c_);
        n = 31 * n + Float.floatToIntBits(this.field_227063_d_);
        n = 31 * n + Float.floatToIntBits(this.field_227064_e_);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quaternion[").append(this.func_195894_d()).append(" + ");
        stringBuilder.append(this.func_195889_a()).append("i + ");
        stringBuilder.append(this.func_195891_b()).append("j + ");
        stringBuilder.append(this.func_195893_c()).append("k]");
        return stringBuilder.toString();
    }

    public float func_195889_a() {
        return this.field_227061_b_;
    }

    public float func_195891_b() {
        return this.field_227062_c_;
    }

    public float func_195893_c() {
        return this.field_227063_d_;
    }

    public float func_195894_d() {
        return this.field_227064_e_;
    }

    public void func_195890_a(Quaternion quaternion) {
        float f = this.func_195889_a();
        \u2603 = this.func_195891_b();
        \u2603 = this.func_195893_c();
        \u2603 = this.func_195894_d();
        \u2603 = quaternion.func_195889_a();
        \u2603 = quaternion.func_195891_b();
        \u2603 = quaternion.func_195893_c();
        \u2603 = quaternion.func_195894_d();
        this.field_227061_b_ = \u2603 * \u2603 + f * \u2603 + \u2603 * \u2603 - \u2603 * \u2603;
        this.field_227062_c_ = \u2603 * \u2603 - f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
        this.field_227063_d_ = \u2603 * \u2603 + f * \u2603 - \u2603 * \u2603 + \u2603 * \u2603;
        this.field_227064_e_ = \u2603 * \u2603 - f * \u2603 - \u2603 * \u2603 - \u2603 * \u2603;
    }

    public void func_195892_e() {
        this.field_227061_b_ = -this.field_227061_b_;
        this.field_227062_c_ = -this.field_227062_c_;
        this.field_227063_d_ = -this.field_227063_d_;
    }

    private static float func_214904_a(float f) {
        return (float)Math.cos(f);
    }

    private static float func_214903_b(float f) {
        return (float)Math.sin(f);
    }
}

