/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HopperContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HopperTileEntity
extends LockableLootTileEntity
implements IHopper,
ITickableTileEntity {
    private NonNullList<ItemStack> field_145900_a = NonNullList.func_191197_a(5, ItemStack.field_190927_a);
    private int field_145901_j = -1;
    private long field_190578_g;

    public HopperTileEntity() {
        super(TileEntityType.field_200987_r);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        super.func_230337_a_(blockState, compoundNBT);
        this.field_145900_a = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        if (!this.func_184283_b(compoundNBT)) {
            ItemStackHelper.func_191283_b(compoundNBT, this.field_145900_a);
        }
        this.field_145901_j = compoundNBT.func_74762_e("TransferCooldown");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        if (!this.func_184282_c(compoundNBT)) {
            ItemStackHelper.func_191282_a(compoundNBT, this.field_145900_a);
        }
        compoundNBT.func_74768_a("TransferCooldown", this.field_145901_j);
        return compoundNBT;
    }

    @Override
    public int func_70302_i_() {
        return this.field_145900_a.size();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        this.func_184281_d(null);
        return ItemStackHelper.func_188382_a(this.func_190576_q(), n, n2);
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this.func_184281_d(null);
        this.func_190576_q().set(n, itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hopper");
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        --this.field_145901_j;
        this.field_190578_g = this.field_145850_b.func_82737_E();
        if (!this.func_145888_j()) {
            this.func_145896_c(0);
            this.func_200109_a(() -> HopperTileEntity.func_145891_a(this));
        }
    }

    private boolean func_200109_a(Supplier<Boolean> supplier) {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        if (!this.func_145888_j() && this.func_195044_w().func_177229_b(HopperBlock.field_176429_b).booleanValue()) {
            boolean bl = false;
            if (!this.func_191420_l()) {
                bl = this.func_145883_k();
            }
            if (!this.func_152105_l()) {
                bl |= supplier.get().booleanValue();
            }
            if (bl) {
                this.func_145896_c(8);
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean func_152105_l() {
        for (ItemStack itemStack : this.field_145900_a) {
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() == itemStack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean func_145883_k() {
        IInventory iInventory = this.func_145895_l();
        if (iInventory == null) {
            return false;
        }
        Direction \u26032 = this.func_195044_w().func_177229_b(HopperBlock.field_176430_a).func_176734_d();
        if (this.func_174919_a(iInventory, \u26032)) {
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            ItemStack itemStack = this.func_70301_a(i).func_77946_l();
            \u2603 = HopperTileEntity.func_174918_a(this, iInventory, this.func_70298_a(i, 1), \u26032);
            if (\u2603.func_190926_b()) {
                iInventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemStack);
        }
        return false;
    }

    private static IntStream func_213972_a(IInventory iInventory, Direction direction) {
        if (iInventory instanceof ISidedInventory) {
            return IntStream.of(((ISidedInventory)iInventory).func_180463_a(direction));
        }
        return IntStream.range(0, iInventory.func_70302_i_());
    }

    private boolean func_174919_a(IInventory iInventory, Direction direction) {
        return HopperTileEntity.func_213972_a(iInventory, direction).allMatch(n -> {
            ItemStack itemStack = iInventory.func_70301_a(n);
            return itemStack.func_190916_E() >= itemStack.func_77976_d();
        });
    }

    private static boolean func_174917_b(IInventory iInventory, Direction direction) {
        return HopperTileEntity.func_213972_a(iInventory, direction).allMatch(n -> iInventory.func_70301_a(n).func_190926_b());
    }

    public static boolean func_145891_a(IHopper iHopper2) {
        IHopper iHopper2;
        IInventory iInventory = HopperTileEntity.func_145884_b(iHopper2);
        if (iInventory != null) {
            Direction direction = Direction.DOWN;
            if (HopperTileEntity.func_174917_b(iInventory, direction)) {
                return false;
            }
            return HopperTileEntity.func_213972_a(iInventory, direction).anyMatch(n -> HopperTileEntity.func_174915_a(iHopper2, iInventory, n, direction));
        }
        for (ItemEntity \u26032 : HopperTileEntity.func_200115_c(iHopper2)) {
            if (!HopperTileEntity.func_200114_a(iHopper2, \u26032)) continue;
            return true;
        }
        return false;
    }

    private static boolean func_174915_a(IHopper iHopper, IInventory iInventory, int n, Direction direction) {
        ItemStack itemStack = iInventory.func_70301_a(n);
        if (!itemStack.func_190926_b() && HopperTileEntity.func_174921_b(iInventory, itemStack, n, direction)) {
            \u2603 = itemStack.func_77946_l();
            \u2603 = HopperTileEntity.func_174918_a(iInventory, iHopper, iInventory.func_70298_a(n, 1), null);
            if (\u2603.func_190926_b()) {
                iInventory.func_70296_d();
                return true;
            }
            iInventory.func_70299_a(n, \u2603);
        }
        return false;
    }

    public static boolean func_200114_a(IInventory iInventory, ItemEntity itemEntity) {
        boolean bl = false;
        ItemStack \u26032 = itemEntity.func_92059_d().func_77946_l();
        ItemStack \u26033 = HopperTileEntity.func_174918_a(null, iInventory, \u26032, null);
        if (\u26033.func_190926_b()) {
            bl = true;
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(\u26033);
        }
        return bl;
    }

    public static ItemStack func_174918_a(@Nullable IInventory iInventory, IInventory iInventory22, ItemStack itemStack2, @Nullable Direction direction) {
        ItemStack itemStack2;
        if (iInventory22 instanceof ISidedInventory && direction != null) {
            ISidedInventory iSidedInventory = (ISidedInventory)iInventory22;
            int[] \u26032 = iSidedInventory.func_180463_a(direction);
            for (int i = 0; i < \u26032.length && !itemStack2.func_190926_b(); ++i) {
                itemStack2 = HopperTileEntity.func_174916_c(iInventory, iInventory22, itemStack2, \u26032[i], direction);
            }
        } else {
            IInventory iInventory22;
            int \u26033 = iInventory22.func_70302_i_();
            for (int i = 0; i < \u26033 && !itemStack2.func_190926_b(); ++i) {
                itemStack2 = HopperTileEntity.func_174916_c(iInventory, iInventory22, itemStack2, i, direction);
            }
        }
        return itemStack2;
    }

    private static boolean func_174920_a(IInventory iInventory, ItemStack itemStack, int n, @Nullable Direction direction) {
        if (!iInventory.func_94041_b(n, itemStack)) {
            return false;
        }
        return !(iInventory instanceof ISidedInventory) || ((ISidedInventory)iInventory).func_180462_a(n, itemStack, direction);
    }

    private static boolean func_174921_b(IInventory iInventory, ItemStack itemStack, int n, Direction direction) {
        return !(iInventory instanceof ISidedInventory) || ((ISidedInventory)iInventory).func_180461_b(n, itemStack, direction);
    }

    private static ItemStack func_174916_c(@Nullable IInventory iInventory, IInventory iInventory22, ItemStack itemStack2, int n, @Nullable Direction direction) {
        ItemStack itemStack2;
        ItemStack itemStack3 = iInventory22.func_70301_a(n);
        if (HopperTileEntity.func_174920_a(iInventory22, itemStack2, n, direction)) {
            int \u26034;
            boolean \u26032 = false;
            \u2603 = iInventory22.func_191420_l();
            if (itemStack3.func_190926_b()) {
                iInventory22.func_70299_a(n, itemStack2);
                itemStack2 = ItemStack.field_190927_a;
                \u26032 = true;
            } else if (HopperTileEntity.func_145894_a(itemStack3, itemStack2)) {
                int \u26033 = itemStack2.func_77976_d() - itemStack3.func_190916_E();
                \u26034 = Math.min(itemStack2.func_190916_E(), \u26033);
                itemStack2.func_190918_g(\u26034);
                itemStack3.func_190917_f(\u26034);
                boolean bl = \u26032 = \u26034 > 0;
            }
            if (\u26032) {
                IInventory iInventory22;
                if (\u2603 && iInventory22 instanceof HopperTileEntity && !(hopperTileEntity = (HopperTileEntity)iInventory22).func_174914_o()) {
                    HopperTileEntity hopperTileEntity;
                    \u26034 = 0;
                    if (iInventory instanceof HopperTileEntity) {
                        HopperTileEntity hopperTileEntity2 = (HopperTileEntity)iInventory;
                        if (hopperTileEntity.field_190578_g >= hopperTileEntity2.field_190578_g) {
                            \u26034 = 1;
                        }
                    }
                    hopperTileEntity.func_145896_c(8 - \u26034);
                }
                iInventory22.func_70296_d();
            }
        }
        return itemStack2;
    }

    @Nullable
    private IInventory func_145895_l() {
        Direction direction = this.func_195044_w().func_177229_b(HopperBlock.field_176430_a);
        return HopperTileEntity.func_195484_a(this.func_145831_w(), this.field_174879_c.func_177972_a(direction));
    }

    @Nullable
    public static IInventory func_145884_b(IHopper iHopper) {
        return HopperTileEntity.func_145893_b(iHopper.func_145831_w(), iHopper.func_96107_aA(), iHopper.func_96109_aB() + 1.0, iHopper.func_96108_aC());
    }

    public static List<ItemEntity> func_200115_c(IHopper iHopper) {
        return iHopper.func_200100_i().func_197756_d().stream().flatMap(axisAlignedBB -> iHopper.func_145831_w().func_175647_a(ItemEntity.class, axisAlignedBB.func_72317_d(iHopper.func_96107_aA() - 0.5, iHopper.func_96109_aB() - 0.5, iHopper.func_96108_aC() - 0.5), EntityPredicates.field_94557_a).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static IInventory func_195484_a(World world, BlockPos blockPos) {
        return HopperTileEntity.func_145893_b(world, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
    }

    @Nullable
    public static IInventory func_145893_b(World world, double d, double d2, double d3) {
        IInventory iInventory = null;
        BlockPos \u26032 = new BlockPos(d, d2, d3);
        BlockState \u26033 = world.func_180495_p(\u26032);
        Block \u26034 = \u26033.func_177230_c();
        if (\u26034 instanceof ISidedInventoryProvider) {
            iInventory = ((ISidedInventoryProvider)((Object)\u26034)).func_219966_a(\u26033, world, \u26032);
        } else if (\u26034.func_235695_q_() && (\u2603 = world.func_175625_s(\u26032)) instanceof IInventory && (iInventory = (IInventory)\u2603) instanceof ChestTileEntity && \u26034 instanceof ChestBlock) {
            iInventory = ChestBlock.func_226916_a_((ChestBlock)\u26034, \u26033, world, \u26032, true);
        }
        if (iInventory == null && !(\u2603 = world.func_175674_a(null, new AxisAlignedBB(d - 0.5, d2 - 0.5, d3 - 0.5, d + 0.5, d2 + 0.5, d3 + 0.5), EntityPredicates.field_96566_b)).isEmpty()) {
            iInventory = (IInventory)\u2603.get(world.field_73012_v.nextInt(\u2603.size()));
        }
        return iInventory;
    }

    private static boolean func_145894_a(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.func_77973_b() != itemStack2.func_77973_b()) {
            return false;
        }
        if (itemStack.func_77952_i() != itemStack2.func_77952_i()) {
            return false;
        }
        if (itemStack.func_190916_E() > itemStack.func_77976_d()) {
            return false;
        }
        return ItemStack.func_77970_a(itemStack, itemStack2);
    }

    @Override
    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    @Override
    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    @Override
    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    private void func_145896_c(int n) {
        this.field_145901_j = n;
    }

    private boolean func_145888_j() {
        return this.field_145901_j > 0;
    }

    private boolean func_174914_o() {
        return this.field_145901_j > 8;
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145900_a;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> nonNullList) {
        this.field_145900_a = nonNullList;
    }

    public void func_200113_a(Entity entity) {
        if (entity instanceof ItemEntity) {
            BlockPos blockPos = this.func_174877_v();
            if (VoxelShapes.func_197879_c(VoxelShapes.func_197881_a(entity.func_174813_aQ().func_72317_d(-blockPos.func_177958_n(), -blockPos.func_177956_o(), -blockPos.func_177952_p())), this.func_200100_i(), IBooleanFunction.field_223238_i_)) {
                this.func_200109_a(() -> HopperTileEntity.func_200114_a(this, (ItemEntity)entity));
            }
        }
    }

    @Override
    protected Container func_213906_a(int n, PlayerInventory playerInventory) {
        return new HopperContainer(n, playerInventory, this);
    }
}

