/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.monster.HoglinTasks;
import net.minecraft.entity.monster.IFlinging;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HoglinEntity
extends AnimalEntity
implements IMob,
IFlinging {
    private static final DataParameter<Boolean> field_234356_bw_ = EntityDataManager.func_187226_a(HoglinEntity.class, DataSerializers.field_187198_h);
    private int field_234357_bx_;
    private int field_234358_by_ = 0;
    private boolean field_234359_bz_ = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super HoglinEntity>>> field_234354_bu_ = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_234132_n_, SensorType.field_234131_m_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> field_234355_bv_ = ImmutableList.of(MemoryModuleType.field_220953_n, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_220951_l, MemoryModuleType.field_220950_k, MemoryModuleType.field_223021_x, MemoryModuleType.field_220954_o, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, MemoryModuleType.field_234092_Z_, (Object[])new MemoryModuleType[]{MemoryModuleType.field_234106_z_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234091_Y_, MemoryModuleType.field_234075_I_, MemoryModuleType.field_234098_af_, MemoryModuleType.field_234099_ag_});

    public HoglinEntity(EntityType<? extends HoglinEntity> entityType, World world) {
        super((EntityType<? extends AnimalEntity>)entityType, world);
        this.field_70728_aV = 5;
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return !this.func_110167_bD();
    }

    public static AttributeModifierMap.MutableAttribute func_234362_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.3f).func_233815_a_(Attributes.field_233820_c_, 0.6f).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        this.field_234357_bx_ = 10;
        this.field_70170_p.func_72960_a(this, (byte)4);
        this.func_184185_a(SoundEvents.field_232714_fD_, 1.0f, this.func_70647_i());
        HoglinTasks.func_234378_a_(this, (LivingEntity)entity);
        return IFlinging.func_234403_a_(this, (LivingEntity)entity);
    }

    @Override
    protected void func_213371_e(LivingEntity livingEntity) {
        if (this.func_234363_eJ_()) {
            IFlinging.func_234404_b_(this, livingEntity);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        boolean bl = super.func_70097_a(damageSource, f);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (bl && damageSource.func_76346_g() instanceof LivingEntity) {
            HoglinTasks.func_234384_b_(this, (LivingEntity)damageSource.func_76346_g());
        }
        return bl;
    }

    protected Brain.BrainCodec<HoglinEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_234355_bv_, field_234354_bu_);
    }

    @Override
    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return HoglinTasks.func_234376_a_(this.func_230289_cH_().func_233748_a_(dynamic));
    }

    public Brain<HoglinEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    @Override
    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("hoglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        HoglinTasks.func_234377_a_(this);
        if (this.func_234364_eK_()) {
            ++this.field_234358_by_;
            if (this.field_234358_by_ > 300) {
                this.func_241412_a_(SoundEvents.field_232715_fE_);
                this.func_234360_a_((ServerWorld)this.field_70170_p);
            }
        } else {
            this.field_234358_by_ = 0;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_234357_bx_ > 0) {
            --this.field_234357_bx_;
        }
        super.func_70636_d();
    }

    @Override
    protected void func_175500_n() {
        if (this.func_70631_g_()) {
            this.field_70728_aV = 3;
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.5);
        } else {
            this.field_70728_aV = 5;
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
        }
    }

    public static boolean func_234361_c_(EntityType<HoglinEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return !iWorld.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_189878_dg);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        if (iServerWorld.func_201674_k().nextFloat() < 0.2f) {
            this.func_82227_f(true);
        }
        return super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.func_104002_bU();
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (HoglinTasks.func_234380_a_(this, blockPos)) {
            return -1.0f;
        }
        if (iWorldReader.func_180495_p(blockPos.func_177977_b()).func_203425_a(Blocks.field_235381_mu_)) {
            return 10.0f;
        }
        return 0.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.func_213302_cg() - (this.func_70631_g_() ? 0.2 : 0.15);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ActionResultType actionResultType = super.func_230254_b_(playerEntity, hand);
        if (actionResultType.func_226246_a_()) {
            this.func_110163_bv();
        }
        return actionResultType;
    }

    @Override
    protected boolean func_146066_aG() {
        return true;
    }

    @Override
    protected int func_70693_a(PlayerEntity playerEntity) {
        return this.field_70728_aV;
    }

    private void func_234360_a_(ServerWorld serverWorld) {
        ZoglinEntity zoglinEntity = this.func_233656_b_(EntityType.field_233590_aW_, true);
        if (zoglinEntity != null) {
            zoglinEntity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
        }
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_234722_bw_;
    }

    public boolean func_234363_eJ_() {
        return !this.func_70631_g_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234356_bw_, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.func_234368_eV_()) {
            compoundNBT.func_74757_a("IsImmuneToZombification", true);
        }
        compoundNBT.func_74768_a("TimeInOverworld", this.field_234358_by_);
        if (this.field_234359_bz_) {
            compoundNBT.func_74757_a("CannotBeHunted", true);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_234370_t_(compoundNBT.func_74767_n("IsImmuneToZombification"));
        this.field_234358_by_ = compoundNBT.func_74762_e("TimeInOverworld");
        this.func_234371_u_(compoundNBT.func_74767_n("CannotBeHunted"));
    }

    public void func_234370_t_(boolean bl) {
        this.func_184212_Q().func_187227_b(field_234356_bw_, bl);
    }

    private boolean func_234368_eV_() {
        return this.func_184212_Q().func_187225_a(field_234356_bw_);
    }

    public boolean func_234364_eK_() {
        return !this.field_70170_p.func_230315_m_().func_241509_i_() && !this.func_234368_eV_() && !this.func_175446_cd();
    }

    private void func_234371_u_(boolean bl) {
        this.field_234359_bz_ = bl;
    }

    public boolean func_234365_eM_() {
        return this.func_234363_eJ_() && !this.field_234359_bz_;
    }

    @Override
    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        HoglinEntity hoglinEntity = EntityType.field_233588_G_.func_200721_a(serverWorld);
        if (hoglinEntity != null) {
            hoglinEntity.func_110163_bv();
        }
        return hoglinEntity;
    }

    @Override
    public boolean func_204701_dC() {
        return !HoglinTasks.func_234386_c_(this) && super.func_204701_dC();
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        return HoglinTasks.func_234398_h_(this).orElse(null);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_232717_fG_;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232716_fF_;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_232719_fI_, 0.15f, 1.0f);
    }

    protected void func_241412_a_(SoundEvent soundEvent) {
        this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a(this);
    }
}

