/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class HopperBlock
extends ContainerBlock {
    public static final DirectionProperty field_176430_a = BlockStateProperties.field_208156_I;
    public static final BooleanProperty field_176429_b = BlockStateProperties.field_208180_g;
    private static final VoxelShape field_196328_c = Block.func_208617_a(0.0, 10.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape field_196339_z = Block.func_208617_a(4.0, 4.0, 4.0, 12.0, 10.0, 12.0);
    private static final VoxelShape field_199607_z = VoxelShapes.func_197872_a(field_196339_z, field_196328_c);
    private static final VoxelShape field_196326_A = VoxelShapes.func_197878_a(field_199607_z, IHopper.field_200101_a, IBooleanFunction.field_223234_e_);
    private static final VoxelShape field_196333_G = VoxelShapes.func_197872_a(field_196326_A, Block.func_208617_a(6.0, 0.0, 6.0, 10.0, 4.0, 10.0));
    private static final VoxelShape field_196334_H = VoxelShapes.func_197872_a(field_196326_A, Block.func_208617_a(12.0, 4.0, 6.0, 16.0, 8.0, 10.0));
    private static final VoxelShape field_196335_I = VoxelShapes.func_197872_a(field_196326_A, Block.func_208617_a(6.0, 4.0, 0.0, 10.0, 8.0, 4.0));
    private static final VoxelShape field_196336_J = VoxelShapes.func_197872_a(field_196326_A, Block.func_208617_a(6.0, 4.0, 12.0, 10.0, 8.0, 16.0));
    private static final VoxelShape field_196337_K = VoxelShapes.func_197872_a(field_196326_A, Block.func_208617_a(0.0, 4.0, 6.0, 4.0, 8.0, 10.0));
    private static final VoxelShape field_199602_G = IHopper.field_200101_a;
    private static final VoxelShape field_199603_H = VoxelShapes.func_197872_a(IHopper.field_200101_a, Block.func_208617_a(12.0, 8.0, 6.0, 16.0, 10.0, 10.0));
    private static final VoxelShape field_199604_I = VoxelShapes.func_197872_a(IHopper.field_200101_a, Block.func_208617_a(6.0, 8.0, 0.0, 10.0, 10.0, 4.0));
    private static final VoxelShape field_199605_J = VoxelShapes.func_197872_a(IHopper.field_200101_a, Block.func_208617_a(6.0, 8.0, 12.0, 10.0, 10.0, 16.0));
    private static final VoxelShape field_199606_K = VoxelShapes.func_197872_a(IHopper.field_200101_a, Block.func_208617_a(0.0, 8.0, 6.0, 4.0, 10.0, 10.0));

    public HopperBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176430_a, Direction.DOWN)).func_206870_a(field_176429_b, true));
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        switch (blockState.func_177229_b(field_176430_a)) {
            case DOWN: {
                return field_196333_G;
            }
            case NORTH: {
                return field_196335_I;
            }
            case SOUTH: {
                return field_196336_J;
            }
            case WEST: {
                return field_196337_K;
            }
            case EAST: {
                return field_196334_H;
            }
        }
        return field_196326_A;
    }

    @Override
    public VoxelShape func_199600_g(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        switch (blockState.func_177229_b(field_176430_a)) {
            case DOWN: {
                return field_199602_G;
            }
            case NORTH: {
                return field_199604_I;
            }
            case SOUTH: {
                return field_199605_J;
            }
            case WEST: {
                return field_199606_K;
            }
            case EAST: {
                return field_199603_H;
            }
        }
        return IHopper.field_200101_a;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        Direction direction = blockItemUseContext.func_196000_l().func_176734_d();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_176430_a, direction.func_176740_k() == Direction.Axis.Y ? Direction.DOWN : direction)).func_206870_a(field_176429_b, true);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new HopperTileEntity();
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof HopperTileEntity) {
            ((HopperTileEntity)\u2603).func_213903_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState2.func_203425_a(blockState.func_177230_c())) {
            return;
        }
        this.func_176427_e(world, blockPos, blockState);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof HopperTileEntity) {
            playerEntity.func_213829_a((HopperTileEntity)tileEntity);
            playerEntity.func_195066_a(Stats.field_188084_R);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        this.func_176427_e(world, blockPos, blockState);
    }

    private void func_176427_e(World world, BlockPos blockPos, BlockState blockState) {
        boolean bl = \u2603 = !world.func_175640_z(blockPos);
        if (\u2603 != blockState.func_177229_b(field_176429_b)) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176429_b, \u2603), 4);
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof HopperTileEntity) {
            InventoryHelper.func_180175_a(world, blockPos, (HopperTileEntity)tileEntity);
            world.func_175666_e(blockPos, this);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return Container.func_178144_a(world.func_175625_s(blockPos));
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176430_a, rotation.func_185831_a(blockState.func_177229_b(field_176430_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_176430_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176430_a, field_176429_b);
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof HopperTileEntity) {
            ((HopperTileEntity)tileEntity).func_200113_a(entity);
        }
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

