/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementManager
extends JsonReloadListener {
    private static final Logger field_192782_a = LogManager.getLogger();
    private static final Gson field_192783_b = new GsonBuilder().create();
    private AdvancementList field_223388_c = new AdvancementList();
    private final LootPredicateManager field_240922_d_;

    public AdvancementManager(LootPredicateManager lootPredicateManager) {
        super(field_192783_b, "advancements");
        this.field_240922_d_ = lootPredicateManager;
    }

    @Override
    protected void func_212853_a_(Map<ResourceLocation, JsonElement> map, IResourceManager iResourceManager, IProfiler iProfiler) {
        HashMap hashMap = Maps.newHashMap();
        map.forEach((resourceLocation, jsonElement) -> {
            try {
                JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "advancement");
                Advancement.Builder \u26032 = Advancement.Builder.func_241043_a_(jsonObject, new ConditionArrayParser((ResourceLocation)resourceLocation, this.field_240922_d_));
                hashMap.put(resourceLocation, \u26032);
            }
            catch (JsonParseException | IllegalArgumentException throwable) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", resourceLocation, (Object)throwable.getMessage());
            }
        });
        AdvancementList \u26032 = new AdvancementList();
        \u26032.func_192083_a(hashMap);
        for (Advancement advancement : \u26032.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a(advancement);
        }
        this.field_223388_c = \u26032;
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation resourceLocation) {
        return this.field_223388_c.func_192084_a(resourceLocation);
    }

    public Collection<Advancement> func_195438_b() {
        return this.field_223388_c.func_195651_c();
    }
}

