/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.md_5.specialsource.AccessChange;
import net.md_5.specialsource.util.FileLocator;

public class AccessMap {
    private Map<String, AccessChange> map = new HashMap<String, AccessChange>();
    private Set<String> appliedMaps = new HashSet<String>();

    public void loadAccessTransformer(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            int n = line.indexOf(35);
            if (n != -1) {
                line = line.substring(0, n);
            }
            if ((line = line.trim()).isEmpty()) continue;
            this.addAccessChange(line);
        }
    }

    public void loadAccessTransformer(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            this.loadAccessTransformer(reader);
        }
    }

    public void loadAccessTransformer(String filename) throws IOException {
        if (filename.startsWith("pattern:")) {
            this.addAccessChange(filename.substring("pattern:".length()));
        } else {
            this.loadAccessTransformer(FileLocator.getFile(filename));
        }
    }

    public static String convertSymbolPattern(String s) {
        if ((s = s.replace('.', '/')).indexOf(40) != -1) {
            s = s.replaceFirst("(?=[^ ])[(]", " (");
        }
        return s;
    }

    public void addAccessChange(String line) {
        int n = line.indexOf(32);
        if (n == -1) {
            throw new IllegalArgumentException("loadAccessTransformer invalid line: " + line);
        }
        String accessString = line.substring(0, n);
        String symbolString = line.substring(n + 1);
        this.addAccessChange(symbolString, accessString);
    }

    public void addAccessChange(String symbolString, String accessString) {
        this.addAccessChange(AccessMap.convertSymbolPattern(symbolString), new AccessChange(accessString));
    }

    public void addAccessChange(String key, AccessChange accessChange) {
        if (this.map.containsKey(key)) {
            System.out.println("INFO: merging AccessMap " + key + " from " + this.map.get(key) + " with " + accessChange);
            this.map.get(key).merge(accessChange);
        } else {
            this.map.put(key, accessChange);
        }
    }

    public int applyClassAccess(String className, int access) {
        int old = access;
        access = this.apply("**", access);
        access = this.apply("*", access);
        access = this.apply(className, access);
        return access;
    }

    public int applyFieldAccess(String className, String fieldName, int access) {
        int old = access;
        access = this.apply("**", access);
        access = this.apply("*/*", access);
        access = this.apply(className + "/*", access);
        access = this.apply(className + "/" + fieldName, access);
        return access;
    }

    public int applyMethodAccess(String className, String methodName, String methodDesc, int access) {
        int old = access;
        access = this.apply("**", access);
        access = this.apply("*/* ()", access);
        access = this.apply(className + "/* ()", access);
        access = this.apply(className + "/" + methodName + " " + methodDesc, access);
        return access;
    }

    private int apply(String key, int existing) {
        AccessChange change = this.map.get(key);
        if (change == null) {
            return existing;
        }
        int newAccess = change.apply(existing);
        if (newAccess != existing) {
            this.appliedMaps.add(key);
        }
        this.accessApplied(key, existing, newAccess);
        return newAccess;
    }

    protected void accessApplied(String key, int oldAccess, int newAccess) {
    }

    public Map<String, AccessChange> getMap() {
        return this.map;
    }

    public Set<String> getAppliedMaps() {
        return this.appliedMaps;
    }
}

