/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class DyeUtils {
    private static final String[] dyeOredicts = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};

    public static boolean isDye(aip stack) {
        return DyeUtils.metaFromStack(stack).isPresent();
    }

    public static OptionalInt metaFromStack(aip stack) {
        if (stack.b()) {
            return OptionalInt.empty();
        }
        return Arrays.stream(OreDictionary.getOreIDs(stack)).mapToObj(OreDictionary::getOreName).mapToInt(name -> ArrayUtils.indexOf((Object[])dyeOredicts, (Object)name)).filter(id -> id >= 0).findFirst();
    }

    public static int rawMetaFromStack(aip stack) {
        return DyeUtils.metaFromStack(stack).orElse(-1);
    }

    public static OptionalInt dyeDamageFromStack(aip stack) {
        OptionalInt meta = DyeUtils.metaFromStack(stack);
        return meta.isPresent() ? OptionalInt.of(15 - meta.getAsInt()) : OptionalInt.empty();
    }

    public static int rawDyeDamageFromStack(aip stack) {
        return DyeUtils.dyeDamageFromStack(stack).orElse(-1);
    }

    public static Optional<ahs> colorFromStack(aip stack) {
        OptionalInt meta = DyeUtils.metaFromStack(stack);
        return meta.isPresent() ? Optional.of(ahs.b((int)meta.getAsInt())) : Optional.empty();
    }
}

