/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.util;

import fi.dy.masa.lowtechcrafting.inventory.IItemHandlerSize;
import fi.dy.masa.lowtechcrafting.inventory.ItemStackHandlerBasic;
import fi.dy.masa.lowtechcrafting.inventory.container.base.SlotRange;
import fi.dy.masa.lowtechcrafting.util.EntityUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static final int SLOT_ITER_LIMIT = 256;
    public static final ItemStackHandlerBasic NULL_INV = new ItemStackHandlerBasic(0);

    public static int calcRedstoneFromInventory(IItemHandler inv) {
        int slots = inv.getSlots();
        int items = 0;
        int capacity = 0;
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            capacity = inv instanceof IItemHandlerSize && !stack.func_190926_b() ? (capacity += ((IItemHandlerSize)inv).getItemStackLimit(slot, stack)) : (capacity += inv.getSlotLimit(slot));
            if (stack.func_190926_b()) continue;
            items += stack.func_190916_E();
        }
        if (capacity > 0) {
            int strength = 14 * items / capacity;
            if (items > 0) {
                ++strength;
            }
            return strength;
        }
        return 0;
    }

    public static void dropInventoryContentsInWorld(World world, BlockPos pos, IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            EntityUtils.dropItemStacksInWorld(world, pos, stack, -1, true);
        }
    }

    public static boolean areItemStacksEqual(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return stack1.func_190926_b() == stack2.func_190926_b();
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areItemStacksOreDictMatch(@Nonnull ItemStack stackTarget, @Nonnull ItemStack stackReference) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stackReference)) {
            NonNullList oreStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)id), (boolean)false);
            for (ItemStack oreStack : oreStacks) {
                if (!OreDictionary.itemMatches((ItemStack)stackTarget, (ItemStack)oreStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getFirstEmptySlot(IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (!inv.getStackInSlot(slot).func_190926_b()) continue;
            return slot;
        }
        return -1;
    }

    public static int getNextNonEmptySlot(IItemHandler inv, int startSlot) {
        int invSize = inv.getSlots();
        int slot = startSlot;
        int i = 0;
        while (i < invSize) {
            if (slot >= invSize) {
                slot = 0;
            }
            if (!inv.getStackInSlot(slot).func_190926_b()) {
                return slot;
            }
            ++i;
            ++slot;
        }
        return -1;
    }

    public static int getSlotOfFirstMatchingItemStack(IItemHandler inv, ItemStack stack) {
        return InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(inv, stack, 0, inv.getSlots());
    }

    public static int getSlotOfFirstMatchingItemStackWithinSlotRange(IItemHandler inv, ItemStack stack, int slotStart, int slotLastExc) {
        int slotLast = Math.min(inv.getSlots() - 1, slotLastExc - 1);
        for (int slot = slotStart; slot <= slotLast; ++slot) {
            ItemStack stackSlot = inv.getStackInSlot(slot);
            if (!InventoryUtils.areItemStacksEqual(stackSlot, stack)) continue;
            return slot;
        }
        return -1;
    }

    public static boolean isInventoryEmpty(IItemHandler inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static boolean doesInventoryMatchTemplate(IItemHandler inv, NonNullList<ItemStack> template) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (InventoryUtils.areItemStacksEqual(inv.getStackInSlot(slot), (ItemStack)template.get(slot))) continue;
            return false;
        }
        return true;
    }

    public static boolean doesInventoryHaveNonMatchingItems(IItemHandler inv, NonNullList<ItemStack> template) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stackTemplate = (ItemStack)template.get(slot);
            ItemStack stackInv = inv.getStackInSlot(slot);
            if (stackInv.func_190926_b() || InventoryUtils.areItemStacksEqual(stackInv, stackTemplate)) continue;
            return true;
        }
        return false;
    }

    public static void setInventoryContents(IItemHandlerModifiable inv, NonNullList<ItemStack> stacks, boolean copy) {
        int invSize = inv.getSlots();
        if (copy) {
            for (int slot = 0; slot < invSize; ++slot) {
                ItemStack stack = (ItemStack)stacks.get(slot);
                inv.setStackInSlot(slot, stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l());
            }
        } else {
            for (int slot = 0; slot < invSize; ++slot) {
                inv.setStackInSlot(slot, (ItemStack)stacks.get(slot));
            }
        }
    }

    public static void clearInventory(IItemHandlerModifiable inv) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            inv.setStackInSlot(slot, ItemStack.field_190927_a);
        }
    }

    public static NonNullList<ItemStack> createInventorySnapshot(IItemHandler inv) {
        int invSize = inv.getSlots();
        NonNullList items = NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            items.set(slot, (Object)stack.func_77946_l());
        }
        return items;
    }

    public static InvResult tryMoveEntireStackOnly(IItemHandler invSrc, int slotSrc, IItemHandler invDst, int slotDst) {
        ItemStack stack = invSrc.extractItem(slotSrc, 64, true);
        if (!stack.func_190926_b() && (stack = invDst.insertItem(slotDst, stack, true)).func_190926_b()) {
            stack = invSrc.extractItem(slotSrc, 64, false);
            int sizeOrig = stack.func_190916_E();
            if (!(stack = invDst.insertItem(slotDst, stack, false)).func_190926_b()) {
                boolean movedSome = stack.func_190916_E() != sizeOrig;
                invSrc.insertItem(slotSrc, stack, false);
                return movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING;
            }
            return InvResult.MOVED_ALL;
        }
        return InvResult.MOVED_NOTHING;
    }

    public static ItemStack tryInsertItemStackToInventory(IItemHandler inv, ItemStack stack, boolean simulate) {
        int invSize = inv.getSlots();
        for (int slot = 0; slot < invSize; ++slot) {
            if (!(stack = inv.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack tryInsertItemStackToInventoryStackFirst(IItemHandler inv, ItemStack stackIn, boolean simulate) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRangeStackFirst(inv, stackIn, 0, inv.getSlots(), simulate);
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRangeStackFirst(IItemHandler inv, ItemStack stack, int slotFirst, int slotLastExc, boolean simulate) {
        int slot;
        int slotLast = Math.min(slotLastExc - 1, inv.getSlots() - 1);
        for (slot = slotFirst; slot <= slotLast; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b() || !(stack = inv.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (slot = slotFirst; slot <= slotLast; ++slot) {
            if (!(stack = inv.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static InvResult tryMoveAllItems(IItemHandler invSrc, IItemHandler invDst) {
        boolean movedAll = true;
        boolean movedSome = false;
        int invSize = invSrc.getSlots();
        block0: for (int slot = 0; slot < invSize; ++slot) {
            ItemStack stack;
            int limit = 256;
            while (limit-- > 0 && !(stack = invSrc.extractItem(slot, 64, false)).func_190926_b()) {
                int sizeOrig = stack.func_190916_E();
                int sizeNew = (stack = InventoryUtils.tryInsertItemStackToInventory(invDst, stack, false)).func_190916_E();
                if (sizeNew != sizeOrig) {
                    movedSome = true;
                }
                if (stack.func_190926_b()) continue;
                invSrc.insertItem(slot, stack, false);
                movedAll = false;
                continue block0;
            }
        }
        return movedAll && movedSome ? InvResult.MOVED_ALL : (movedSome ? InvResult.MOVED_SOME : InvResult.MOVED_NOTHING);
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRange(IItemHandler inv, @Nonnull ItemStack stack, int slotStart, int slotLastExc) {
        int slot;
        int lastSlot = Math.min(slotLastExc - 1, inv.getSlots() - 1);
        for (slot = slotStart; slot <= lastSlot; ++slot) {
            if (inv.getStackInSlot(slot).func_190926_b() || !(stack = inv.insertItem(slot, stack, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (slot = slotStart; slot <= lastSlot; ++slot) {
            if (!(stack = inv.insertItem(slot, stack, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static InvResult tryMoveStackToOtherInventory(IItemHandler invSrc, IItemHandler invDst, int slotSrc) {
        InvResult result = InvResult.MOVED_NOTHING;
        for (int limit = 256; limit > 0; --limit) {
            ItemStack stack = invSrc.extractItem(slotSrc, 64, true);
            if (stack.func_190926_b()) {
                return limit < 256 ? InvResult.MOVED_ALL : InvResult.MOVED_NOTHING;
            }
            int sizeOrig = stack.func_190916_E();
            int sizeNew = (stack = InventoryUtils.tryInsertItemStackToInventory(invDst, stack, false)).func_190916_E();
            if (sizeNew != sizeOrig) {
                invSrc.extractItem(slotSrc, sizeOrig - sizeNew, false);
                result = InvResult.MOVED_SOME;
            }
            if (sizeNew > 0) break;
        }
        return result;
    }

    public static InvResult tryMoveStackToSmallestStackInOtherInventory(IItemHandler invSrc, IItemHandler invDst, int slotSrc, List<Integer> targetSlots) {
        int slotSmallest = -1;
        int countSmallest = -1;
        for (int slot : targetSlots) {
            int count = invDst.getStackInSlot(slot).func_190916_E();
            if (countSmallest >= 0 && count >= countSmallest) continue;
            countSmallest = count;
            slotSmallest = slot;
        }
        if (slotSmallest != -1) {
            return InventoryUtils.tryMoveStack(invSrc, slotSrc, invDst, slotSmallest, 64);
        }
        return InvResult.MOVED_NOTHING;
    }

    public static InvResult tryMoveStack(IItemHandler invSrc, int slotSrc, IItemHandler invDst, int slotDst) {
        return InventoryUtils.tryMoveStack(invSrc, slotSrc, invDst, slotDst, 64);
    }

    public static InvResult tryMoveStack(IItemHandler invSrc, int slotSrc, IItemHandler invDst, int slotDst, int maxAmount) {
        ItemStack stack = invSrc.extractItem(slotSrc, maxAmount, true);
        if (!stack.func_190926_b()) {
            int sizeOrig = stack.func_190916_E();
            int sizeNew = (stack = invDst.insertItem(slotDst, stack, false)).func_190916_E();
            if (sizeNew != sizeOrig) {
                invSrc.extractItem(slotSrc, sizeOrig - sizeNew, false);
                return sizeNew == 0 ? InvResult.MOVED_ALL : InvResult.MOVED_SOME;
            }
        }
        return InvResult.MOVED_NOTHING;
    }

    public static ItemStack extractItemsFromSlot(IItemHandler inv, int slot, int amount) {
        ItemStack stackTmp;
        ItemStack stackExtract = inv.extractItem(slot, amount, false);
        if (stackExtract.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stackExtract.func_77976_d() * 256 < amount && inv instanceof IItemHandlerModifiable) {
            amount -= stackExtract.func_190916_E();
            ItemStack stackSlot = inv.getStackInSlot(slot);
            if (!stackSlot.func_190926_b()) {
                if (stackSlot.func_190916_E() <= amount) {
                    stackExtract.func_190917_f(stackSlot.func_190916_E());
                    ((IItemHandlerModifiable)inv).setStackInSlot(slot, ItemStack.field_190927_a);
                } else {
                    stackExtract.func_190917_f(amount);
                    stackSlot = stackSlot.func_77946_l();
                    stackSlot.func_190918_g(amount);
                    ((IItemHandlerModifiable)inv).setStackInSlot(slot, stackSlot);
                }
            }
            return stackExtract;
        }
        for (int loops = 0; stackExtract.func_190916_E() < amount && loops < 256 && !(stackTmp = inv.extractItem(slot, amount - stackExtract.func_190916_E(), false)).func_190926_b(); ++loops) {
            stackExtract.func_190917_f(stackTmp.func_190916_E());
        }
        return stackExtract;
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, @Nonnull ItemStack stackTemplate, int maxAmount, boolean reverse) {
        return InventoryUtils.collectItemsFromInventory(inv, stackTemplate, maxAmount, reverse, false);
    }

    public static ItemStack collectItemsFromInventory(IItemHandler inv, @Nonnull ItemStack stackTemplate, int maxAmount, boolean reverse, boolean useOreDict) {
        return InventoryUtils.collectItemsFromInventoryFromSlotRange(inv, stackTemplate, new SlotRange(inv), maxAmount, reverse, useOreDict);
    }

    public static ItemStack collectItemsFromInventoryFromSlotRange(IItemHandler inv, @Nonnull ItemStack stackTemplate, SlotRange range, int amount, boolean reverse, boolean useOreDict) {
        if (range.first >= inv.getSlots()) {
            return ItemStack.field_190927_a;
        }
        int inc = reverse ? -1 : 1;
        int lastSlot = Math.min(range.lastInc, inv.getSlots() - 1);
        int start = reverse ? lastSlot : range.first;
        ItemStack stack = stackTemplate.func_77946_l();
        stack.func_190920_e(0);
        for (int slot = start; slot >= range.first && slot <= lastSlot && stack.func_190916_E() < amount; slot += inc) {
            ItemStack stackTmp = inv.getStackInSlot(slot);
            if (stackTmp.func_190926_b()) continue;
            if (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate)) {
                stackTmp = InventoryUtils.extractItemsFromSlot(inv, slot, amount - stack.func_190916_E());
                if (stackTmp.func_190926_b()) continue;
                stack.func_190917_f(stackTmp.func_190916_E());
                continue;
            }
            if (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate)) continue;
            if (stack.func_190916_E() == 0) {
                stack = stackTmp.func_77946_l();
                stack.func_190920_e(0);
            }
            if ((stackTmp = InventoryUtils.extractItemsFromSlot(inv, slot, amount - stack.func_190916_E())).func_190926_b()) continue;
            stack.func_190917_f(stackTmp.func_190916_E());
        }
        return stack.func_190916_E() > 0 ? stack : ItemStack.field_190927_a;
    }

    public static int getFirstNonEmptySlot(IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getItemsFromFirstNonEmptySlot(IItemHandler inv, int maxAmount, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.extractItem(i, maxAmount, simulate);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static boolean tryShiftSlots(IItemHandlerModifiable inv, int startSlot, boolean backwards) {
        if (startSlot < 0 || startSlot >= inv.getSlots()) {
            return false;
        }
        if (backwards && inv.getStackInSlot(startSlot).func_190926_b()) {
            int lastSlot = inv.getSlots() - 2;
            for (int slot = startSlot; slot <= lastSlot; ++slot) {
                inv.setStackInSlot(slot, inv.getStackInSlot(slot + 1));
            }
            inv.setStackInSlot(inv.getSlots() - 1, ItemStack.field_190927_a);
            return true;
        }
        if (!backwards && inv.getStackInSlot(inv.getSlots() - 1).func_190926_b()) {
            for (int slot = inv.getSlots() - 1; slot > startSlot; --slot) {
                inv.setStackInSlot(slot, inv.getStackInSlot(slot - 1));
            }
            inv.setStackInSlot(startSlot, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public static enum InvResult {
        NO_WORK,
        MOVED_NOTHING,
        MOVED_SOME,
        MOVED_ALL;

    }
}

