/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.lowtechcrafting.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityUtils {
    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks) {
        EntityUtils.dropItemStacksInWorld(worldIn, pos, stack, amountOverride, dropFullStacks, true);
    }

    public static void dropItemStacksInWorld(World worldIn, BlockPos pos, ItemStack stack, int amountOverride, boolean dropFullStacks, boolean randomMotion) {
        double x = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177958_n();
        double y = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177956_o();
        double z = (double)worldIn.field_73012_v.nextFloat() * -0.5 + 0.75 + (double)pos.func_177952_p();
        EntityUtils.dropItemStacksInWorld(worldIn, new Vec3d(x, y, z), stack, amountOverride, dropFullStacks, randomMotion);
    }

    public static void dropItemStacksInWorld(World worldIn, Vec3d pos, ItemStack stack, int amountOverride, boolean dropFullStacks, boolean randomMotion) {
        int max;
        int amount = stack.func_190916_E();
        int num = max = stack.func_77976_d();
        if (amountOverride > 0) {
            amount = amountOverride;
        }
        while (amount > 0) {
            if (!dropFullStacks) {
                num = Math.min(worldIn.field_73012_v.nextInt(23) + 10, max);
            }
            num = Math.min(num, amount);
            amount -= num;
            ItemStack dropStack = stack.func_77946_l();
            dropStack.func_190920_e(num);
            EntityItem entityItem = new EntityItem(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, dropStack);
            if (randomMotion) {
                double motionScale = 0.04;
                entityItem.field_70159_w = worldIn.field_73012_v.nextGaussian() * motionScale;
                entityItem.field_70181_x = worldIn.field_73012_v.nextGaussian() * motionScale + 0.3;
                entityItem.field_70179_y = worldIn.field_73012_v.nextGaussian() * motionScale;
            } else {
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.0;
                entityItem.field_70179_y = 0.0;
            }
            worldIn.func_72838_d((Entity)entityItem);
        }
    }
}

