/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.CapabilitySummonableEntity;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSummonable
implements IMessage {
    private String entityId;
    private String summonerId;
    private boolean following;
    private int timeLimit;

    public MessageSummonable() {
    }

    public MessageSummonable(String entityInID, String summonerInID, boolean following, int timeLimit) {
        this.entityId = entityInID;
        this.summonerId = summonerInID;
        this.following = following;
        this.timeLimit = timeLimit;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.summonerId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.following = buf.readBoolean();
        this.timeLimit = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.summonerId);
        buf.writeBoolean(this.following);
        buf.writeInt(this.timeLimit);
    }

    public static class Handler
    implements IMessageHandler<MessageSummonable, IMessage> {
        public IMessage onMessage(MessageSummonable message, MessageContext ctx) {
            MultiMob.proxy.getThreadListener(ctx).func_152344_a(() -> {
                EntityLivingBase entity;
                if (!message.entityId.isEmpty() && !message.summonerId.isEmpty() && (entity = EntityUtil.getLoadedEntityByUUID((UUID)UUID.fromString(message.entityId), (World)MultiMob.proxy.getClientWorld())) != null && entity.hasCapability(CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null)) {
                    ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)entity, CapabilitySummonableEntity.SUMMONABLE_ENTITY_CAPABILITY, null);
                    summonable.setSummonedEntity(true);
                    summonable.setSummoner(UUID.fromString(message.summonerId));
                    summonable.setFollowing(message.following);
                    summonable.setTimeLimit(message.timeLimit);
                    NBTTagCompound nbttagcompound = entity.func_189511_e(new NBTTagCompound());
                    nbttagcompound.func_74778_a("Owner", message.summonerId);
                    nbttagcompound.func_74778_a("OwnerUUID", message.summonerId);
                    nbttagcompound.func_74757_a("Tame", true);
                    nbttagcompound.func_74757_a("Tamed", true);
                    entity.func_70020_e(nbttagcompound);
                }
            });
            return null;
        }
    }
}

