/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.core;

import java.io.File;
import net.daveyx0.summoner.common.TheSummonerCommonProxy;
import net.daveyx0.summoner.config.TheSummonerConfig;
import net.daveyx0.summoner.core.SummonGroupRegistry;
import net.daveyx0.summoner.core.TheSummonerCapabilities;
import net.daveyx0.summoner.core.TheSummonerEntityRegistry;
import net.daveyx0.summoner.core.TheSummonerLootTables;
import net.daveyx0.summoner.core.TheSummonerMessageRegistry;
import net.daveyx0.summoner.core.TheSummonerSpawnRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="thesummoner", name="The Summoner", version="1.0.1-beta", acceptedMinecraftVersions="[1.12]", guiFactory="net.daveyx0.summoner.config.TheSummonerFactoryGui", dependencies="required-after:multimob")
public class TheSummoner {
    @Mod.Instance(value="thesummoner")
    public static TheSummoner instance = new TheSummoner();
    @SidedProxy(clientSide="net.daveyx0.summoner.client.TheSummonerClientProxy", serverSide="net.daveyx0.summoner.common.TheSummonerCommonProxy")
    public static TheSummonerCommonProxy proxy;
    private File directory;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TheSummoner());
        this.directory = new File(event.getModConfigurationDirectory(), "thesummoner");
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        TheSummonerConfig.load(event);
        TheSummonerMessageRegistry.registerMessages();
        TheSummonerEntityRegistry.registerEntities();
        TheSummonerCapabilities.preInit();
        TheSummonerLootTables.registerLootTables();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        TheSummonerSpawnRegistry.registerSpawns();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SummonGroupRegistry.registerSummonGroups();
        proxy.postInit(event);
    }

    public File getDirectory() {
        return this.directory;
    }
}

