/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.core;

import java.util.List;
import net.daveyx0.summoner.item.ItemSummonerOrb;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SummonGroup {
    public int id;
    public double[] particleSpeed;
    private List<NBTTagCompound> entityTags;
    public int weight;

    public SummonGroup(int idIn, List<NBTTagCompound> tags, int weight) {
        this.id = idIn;
        this.particleSpeed = new double[]{0.7, 0.7, 0.8};
        this.weight = weight;
        this.entityTags = tags;
    }

    public int getAmountToSummon() {
        if (this.entityTags == null || this.entityTags.isEmpty()) {
            return 0;
        }
        return this.entityTags.size();
    }

    public EntityLiving getEntityFromIndex(int index, World worldServerIn, EntityLivingBase owner) {
        if (index > this.entityTags.size()) {
            return null;
        }
        EntityLiving entity = null;
        if (this.entityTags.get(index) != null) {
            entity = ItemSummonerOrb.getEntityWithData(this.entityTags.get(index), worldServerIn, owner);
        }
        return entity;
    }
}

