/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.common.capabilities;

import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class SummonableEntityHandler
implements ISummonableEntity {
    protected UUID summonerID;
    protected boolean isSummoned;
    protected boolean isFollowing;
    protected int timeLimit = 1000;

    public SummonableEntityHandler() {
        this.summonerID = null;
        this.isSummoned = false;
        this.isFollowing = false;
    }

    public SummonableEntityHandler(UUID id) {
        this.summonerID = id;
        this.isSummoned = true;
        this.isFollowing = true;
    }

    @Override
    @Nullable
    public EntityLivingBase getSummoner(EntityLivingBase entityIn) {
        try {
            UUID uuid = this.getSummonerId();
            if (uuid != null) {
                EntityPlayer player = entityIn.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityUtil.getLoadedEntityByUUID((UUID)uuid, (World)entityIn.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase thisEntity, EntityLivingBase entityIn) {
        return entityIn == this.getSummoner(thisEntity);
    }

    @Override
    public void setSummoner(UUID id) {
        this.summonerID = id;
    }

    @Override
    public boolean isSummonedEntity() {
        return this.isSummoned;
    }

    @Override
    public void setSummonedEntity(boolean set) {
        this.isSummoned = set;
    }

    @Override
    public UUID getSummonerId() {
        return this.summonerID;
    }

    @Override
    public boolean isFollowing() {
        return this.isFollowing;
    }

    @Override
    public void setFollowing(boolean set) {
        this.isFollowing = set;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(int ticks) {
        this.timeLimit = ticks;
    }

    private static class Factory
    implements Callable<ISummonableEntity> {
        private Factory() {
        }

        @Override
        public ISummonableEntity call() throws Exception {
            return new SummonableEntityHandler();
        }
    }
}

