/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.summoner.common.capabilities;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.daveyx0.multimob.capabilities.CapabilityProviderSerializable;
import net.daveyx0.multimob.message.MMMessageRegistry;
import net.daveyx0.multimob.message.MessageMMParticle;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.summoner.common.capabilities.ISummonableEntity;
import net.daveyx0.summoner.common.capabilities.SummonableEntityHandler;
import net.daveyx0.summoner.config.TheSummonerConfig;
import net.daveyx0.summoner.core.TheSummoner;
import net.daveyx0.summoner.entity.EntitySummoningIllager;
import net.daveyx0.summoner.entity.ai.EntityAISummonFollowOwner;
import net.daveyx0.summoner.entity.ai.EntityAISummonOwnerHurtByTarget;
import net.daveyx0.summoner.entity.ai.EntityAISummonOwnerHurtTarget;
import net.daveyx0.summoner.item.ItemSummonerOrb;
import net.daveyx0.summoner.message.MessageSummonable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CapabilitySummonableEntity {
    @CapabilityInject(value=ISummonableEntity.class)
    public static Capability<ISummonableEntity> SUMMONABLE_ENTITY_CAPABILITY = null;
    public static final ResourceLocation capabilityID = new ResourceLocation("multimob", "Summonable");

    public static void register() {
        CapabilityManager.INSTANCE.register(ISummonableEntity.class, (Capability.IStorage)new Capability.IStorage<ISummonableEntity>(){

            public NBTBase writeNBT(Capability<ISummonableEntity> capability, ISummonableEntity instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                UUID summoner = instance.getSummonerId();
                if (summoner == null) {
                    compound.func_74778_a("SummonerUUID", "");
                } else {
                    compound.func_74778_a("SummonerUUID", summoner.toString());
                }
                compound.func_74757_a("Following", instance.isFollowing());
                compound.func_74768_a("TimeLimit", instance.getTimeLimit());
                return compound;
            }

            public void readNBT(Capability<ISummonableEntity> capability, ISummonableEntity instance, EnumFacing side, NBTBase base) {
                NBTTagCompound compound = (NBTTagCompound)base;
                String s = "";
                if (compound.func_150297_b("SummonerUUID", 8)) {
                    s = compound.func_74779_i("SummonerUUID");
                }
                if (!s.isEmpty()) {
                    try {
                        instance.setSummoner(UUID.fromString(s));
                        instance.setSummonedEntity(true);
                    }
                    catch (Throwable var4) {
                        instance.setSummonedEntity(false);
                    }
                }
                instance.setFollowing(compound.func_74767_n("Following"));
                instance.setTimeLimit(compound.func_74762_e("TimeLimit"));
            }
        }, SummonableEntityHandler::new);
    }

    @Mod.EventBusSubscriber(modid="thesummoner")
    public static class EventHandler {
        @SubscribeEvent
        public static void AttachEntityCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() != null && event.getObject() instanceof EntityLiving) {
                event.addCapability(capabilityID, (ICapabilityProvider)new CapabilityProviderSerializable(SUMMONABLE_ENTITY_CAPABILITY));
            }
        }

        @SubscribeEvent
        public static void EntityLivingDeathEvent(LivingDeathEvent event) {
            if (EventHandler.isEntitySuitableForSummon((Entity)event.getEntityLiving())) {
                ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getEntity(), SUMMONABLE_ENTITY_CAPABILITY, null);
                EntityLiving entity = (EntityLiving)event.getEntityLiving();
                if (EventHandler.spiritCanBeCaptured(entity, summonable, event.getSource()) || summonable != null && summonable.isSummonedEntity()) {
                    if (summonable.isSummonedEntity()) {
                        entity.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
                    }
                    EntityPlayer player = null;
                    if (!summonable.isSummonedEntity()) {
                        player = (EntityPlayer)event.getSource().func_76346_g();
                    } else if (summonable.isSummonedEntity() && summonable.getSummoner((EntityLivingBase)entity) instanceof EntityPlayer) {
                        player = (EntityPlayer)summonable.getSummoner((EntityLivingBase)entity);
                    }
                    if (TheSummonerConfig.getMobBlackList() != null) {
                        for (String str : TheSummonerConfig.getMobBlackList()) {
                            if (ForgeRegistries.ENTITIES.getValue(new ResourceLocation(str)) == null || ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(str))).getEntityClass() != entity.getClass()) continue;
                            return;
                        }
                    }
                    if (player != null) {
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            ItemStack item = player.field_71071_by.func_70301_a(i);
                            if (item.func_190926_b() || !(item.func_77973_b() instanceof ItemSummonerOrb) || item.func_77978_p() != null && item.func_77978_p().func_74764_b("RegistryNameDomain")) continue;
                            ItemSummonerOrb.setEntityData(item, entity, player);
                            event.setCanceled(true);
                            entity.func_70106_y();
                            if (entity.func_130014_f_().field_72995_K) break;
                            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.ENCHANTMENT_TABLE.func_179348_c(), 50, (float)entity.field_70165_t + 0.5f, (float)entity.field_70163_u + 0.5f, (float)entity.field_70161_v + 0.5f, 0.0, 0.0, 0.0, 0));
                            break;
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void JoinWorldEvent(EntityJoinWorldEvent event) {
            if (EventHandler.isEntitySuitableForSummon(event.getEntity())) {
                EntityLiving entity = (EntityLiving)event.getEntity();
                ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getEntity(), SUMMONABLE_ENTITY_CAPABILITY, null);
                if (summonable != null && summonable.isSummonedEntity()) {
                    EventHandler.updateEntityTargetAI(entity);
                    entity.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAISummonFollowOwner).findFirst().ifPresent(taskEntry -> entity.field_70714_bg.func_85156_a(taskEntry.field_75733_a));
                    if (summonable.isFollowing()) {
                        entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISummonFollowOwner(entity, 1.2, 8.0f, 2.0f));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void EntityUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            if (EventHandler.isEntitySuitableForSummon((Entity)event.getEntityLiving())) {
                EntityLiving entity = (EntityLiving)event.getEntity();
                ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getEntity(), SUMMONABLE_ENTITY_CAPABILITY, null);
                if (summonable != null && summonable.isSummonedEntity()) {
                    if (entity.field_70170_p.field_73012_v.nextInt(5) == 0) {
                        entity.func_130014_f_().func_175688_a(EnumParticleTypes.CRIT, entity.field_70165_t + (double)(entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()), entity.field_70163_u + (double)entity.field_70170_p.field_73012_v.nextFloat() + 1.0, entity.field_70161_v + (double)(entity.field_70170_p.field_73012_v.nextFloat() - entity.field_70170_p.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                    }
                    if (!summonable.isFollowing()) {
                        entity.func_70661_as().func_75499_g();
                        entity.func_70659_e(0.0f);
                        entity.func_70624_b(null);
                    }
                    if (summonable.getTimeLimit() != -1) {
                        if (summonable.getTimeLimit() > 0) {
                            summonable.setTimeLimit(summonable.getTimeLimit() - 1);
                        } else {
                            ForgeHooks.onLivingDeath((EntityLivingBase)entity, (DamageSource)DamageSource.field_76377_j);
                            entity.func_70606_j(0.0f);
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void PlayerStartsTrackingEvent(PlayerEvent.StartTracking event) {
            ISummonableEntity summonable;
            if (!event.getEntityPlayer().func_130014_f_().field_72995_K && EventHandler.isEntitySuitableForSummon(event.getTarget()) && (summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getTarget(), SUMMONABLE_ENTITY_CAPABILITY, null)).getSummonerId() != null) {
                MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageSummonable(event.getTarget().func_110124_au().toString(), summonable.getSummonerId().toString(), summonable.isFollowing(), summonable.getTimeLimit()), new NetworkRegistry.TargetPoint(event.getEntityPlayer().field_71093_bK, event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, 255.0));
            }
        }

        @SubscribeEvent
        public static void EntityDespawnEvent(LivingSpawnEvent.AllowDespawn event) {
            ISummonableEntity summonable;
            if (EventHandler.isEntitySuitableForSummon(event.getEntity()) && (summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getEntity(), SUMMONABLE_ENTITY_CAPABILITY, null)) != null && summonable.isSummonedEntity() && event.getEntityLiving() != null && !(summonable.getSummoner(event.getEntityLiving()) instanceof EntitySummoningIllager)) {
                event.setResult(Event.Result.DENY);
            }
        }

        @SubscribeEvent
        public static void EntityDropsEvent(LivingDropsEvent event) {
            ISummonableEntity summonable;
            if (EventHandler.isEntitySuitableForSummon(event.getEntity()) && (summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getEntity(), SUMMONABLE_ENTITY_CAPABILITY, null)) != null && summonable.isSummonedEntity()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void PlayerInteractEvent(PlayerInteractEvent.EntityInteract event) throws IOException {
            if (EventHandler.isEntitySuitableForSummon(event.getTarget()) && event.getHand() == EnumHand.MAIN_HAND) {
                EntityLiving entity = (EntityLiving)event.getTarget();
                ISummonableEntity summonable = (ISummonableEntity)EntityUtil.getCapability((Entity)event.getTarget(), SUMMONABLE_ENTITY_CAPABILITY, null);
                if (summonable != null && summonable.isSummonedEntity() && summonable.getSummoner((EntityLivingBase)entity) == event.getEntityPlayer()) {
                    if (event.getEntityPlayer().func_70093_af()) {
                        if (!event.getEntity().func_130014_f_().field_72995_K) {
                            MMMessageRegistry.getNetwork().sendToAll((IMessage)new MessageMMParticle(EnumParticleTypes.NOTE.func_179348_c(), 15, (float)entity.field_70165_t + 0.5f, (float)entity.field_70163_u + 0.5f, (float)entity.field_70161_v + 0.5f, 0.0, 0.0, 0.0, 0));
                        }
                        summonable.setFollowing(!summonable.isFollowing());
                        MMMessageRegistry.getNetwork().sendToAllAround((IMessage)new MessageSummonable(event.getTarget().func_110124_au().toString(), summonable.getSummonerId().toString(), summonable.isFollowing(), summonable.getTimeLimit()), new NetworkRegistry.TargetPoint(event.getEntityPlayer().field_71093_bK, event.getTarget().field_70165_t, event.getTarget().field_70163_u, event.getTarget().field_70161_v, 255.0));
                        if (summonable.isFollowing()) {
                            EventHandler.updateEntityTargetAI(entity);
                            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("%1$s is now following.", new Object[]{event.getTarget().func_145748_c_()}));
                            entity.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISummonFollowOwner(entity, 1.2, 8.0f, 2.0f));
                        } else {
                            EventHandler.resetEntityTargetAI(entity);
                            entity.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAISummonFollowOwner).findFirst().ifPresent(taskEntry -> entity.field_70714_bg.func_85156_a(taskEntry.field_75733_a));
                            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("%1$s is now sitting.", new Object[]{event.getTarget().func_145748_c_()}));
                        }
                    } else if (entity.func_82171_bF() && !event.getEntity().func_130014_f_().field_72995_K) {
                        event.getEntityPlayer().func_184220_m((Entity)entity);
                    }
                }
                if (summonable != null && (summonable.isSummonedEntity() && summonable.getSummoner((EntityLivingBase)entity) == event.getEntityPlayer() || !summonable.isSummonedEntity() && event.getEntityPlayer().func_184812_l_()) && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() instanceof ItemSummonerOrb && event.getHand() == EnumHand.MAIN_HAND) {
                    if (TheSummonerConfig.getMobBlackList() != null) {
                        for (String str : TheSummonerConfig.getMobBlackList()) {
                            if (ForgeRegistries.ENTITIES.getValue(new ResourceLocation(str)) == null || ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(str))).getEntityClass() != entity.getClass()) continue;
                            return;
                        }
                    }
                    if (event.getEntityPlayer().func_184586_b(event.getHand()).func_77978_p() == null || !event.getEntityPlayer().func_184586_b(event.getHand()).func_77978_p().func_74764_b("RegistryNameDomain")) {
                        ItemSummonerOrb orb = (ItemSummonerOrb)event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b();
                        if (TheSummonerConfig.getEditMode()) {
                            EventHandler.createSummonerCreature(EventHandler.getSummonGroupDirectory(), event.getEntityPlayer().func_184586_b(event.getHand()).func_82833_r(), entity.func_70005_c_(), ItemSummonerOrb.getEntityNBT(entity));
                        }
                        ItemSummonerOrb.setEntityData(event.getEntityPlayer().func_184586_b(event.getHand()), entity, event.getEntityPlayer());
                    }
                    if (!event.getEntityPlayer().func_130014_f_().field_72995_K) {
                        entity.func_70106_y();
                    }
                }
            }
        }

        public static File getSummonGroupDirectory() {
            File subDirectory = new File(TheSummoner.instance.getDirectory(), "summongroups");
            if (!subDirectory.exists()) {
                subDirectory.mkdirs();
            }
            return subDirectory;
        }

        public static void createSummonerCreature(File directory, String folderName, String entityName, NBTTagCompound compound) {
            File subDirectory = new File(directory, folderName);
            if (!subDirectory.exists()) {
                subDirectory.mkdirs();
            }
            Object compoundo = null;
            File file = new File(subDirectory, entityName);
            try {
                CompressedStreamTools.func_74793_a((NBTTagCompound)compound, (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public static void resetEntityTargetAI(EntityLiving base) {
            while (base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().isPresent()) {
                base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().ifPresent(taskEntry -> base.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
            }
        }

        public static void updateEntityTargetAI(EntityLiving base) {
            while (base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().isPresent()) {
                base.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof EntityAIBase).findFirst().ifPresent(taskEntry -> base.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
            }
            base.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAISummonOwnerHurtByTarget(base));
            base.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAISummonOwnerHurtTarget(base));
        }

        public static boolean isEntitySuitableForSummon(Entity entity) {
            return entity != null && entity instanceof EntityLiving && entity.hasCapability(SUMMONABLE_ENTITY_CAPABILITY, null);
        }

        public static boolean spiritCanBeCaptured(EntityLiving entity, ISummonableEntity summonable, DamageSource source) {
            return entity != null && summonable != null && !summonable.isSummonedEntity() && source != null && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && (int)entity.func_110138_aP() >= 0 && entity.func_130014_f_().field_73012_v.nextInt((int)entity.func_110138_aP() + 1) == 0;
        }
    }
}

