/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mushroom.midnight.common.world.feature.MidnightAbstractFeature;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class BoulderFeature
extends MidnightAbstractFeature {
    protected final float radius;

    protected BoulderFeature(float radius) {
        this.radius = radius;
    }

    @Override
    public boolean placeFeature(World world, Random random, BlockPos origin) {
        origin = origin.func_177981_b(MathHelper.func_76141_d((float)(this.radius / 2.0f)));
        this.generateBlob(world, random, origin, this.radius);
        for (int i = 0; i < 2; ++i) {
            int offsetX = random.nextInt(5) - 2;
            int offsetY = -random.nextInt(2);
            int offsetZ = random.nextInt(5) - 2;
            BlockPos center = origin.func_177982_a(offsetX, offsetY, offsetZ);
            float radius = this.radius + random.nextFloat() * 0.5f;
            this.generateBlob(world, random, center, radius);
        }
        return true;
    }

    private void generateBlob(World world, Random random, BlockPos origin, float radius) {
        float radiusSquare = radius * radius;
        int radiusCeil = MathHelper.func_76123_f((float)radius);
        BlockPos minPos = origin.func_177982_a(-radiusCeil, -radiusCeil, -radiusCeil);
        BlockPos maxPos = origin.func_177982_a(radiusCeil, radiusCeil, radiusCeil);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)minPos, (BlockPos)maxPos)) {
            double d;
            double dist = pos.func_177951_i((Vec3i)origin);
            if (!(d <= (double)radiusSquare)) continue;
            this.func_175903_a(world, pos, this.getStateForPlacement(world, origin, pos, dist, radiusSquare, random));
        }
    }

    protected abstract IBlockState getStateForPlacement(World var1, BlockPos var2, BlockPos var3, double var4, float var6, Random var7);
}

