/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.biome.cavern.CavernStructureConfig;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.biome.surface.SurfaceBiome;
import com.mushroom.midnight.common.biome.surface.SurfaceTerrainConfig;
import com.mushroom.midnight.common.util.Curve;
import com.mushroom.midnight.common.util.RegionInterpolator;
import com.mushroom.midnight.common.world.noise.OctaveNoiseSampler;
import com.mushroom.midnight.common.world.noise.PerlinNoiseSampler;
import com.mushroom.midnight.common.world.util.BiomeWeightTable;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class MidnightNoiseGenerator {
    private static final BiomeProperties BIOME_PROPERTIES = new BiomeProperties();
    public static final int HORIZONTAL_GRANULARITY = 4;
    public static final int VERTICAL_GRANULARITY = 4;
    public static final int NOISE_WIDTH = 4;
    public static final int NOISE_HEIGHT = 64;
    private static final int BUFFER_WIDTH = 5;
    private static final int BUFFER_HEIGHT = 65;
    private static final int BIOME_WEIGHT_RADIUS = 2;
    public static final int BIOME_NOISE_OFFSET = 2;
    public static final int BIOME_NOISE_SIZE = 9;
    private final OctaveNoiseSampler worldNoise;
    private final OctaveNoiseSampler surfaceNoise;
    private final OctaveNoiseSampler ceilingNoise;
    private final OctaveNoiseSampler ridgedSurfaceNoise;
    private final PerlinNoiseSampler pillarNoise;
    private final double[] worldNoiseBuffer = new double[1625];
    private final double[] terrainBuffer = new double[1625];
    private final double[] surfaceBuffer = new double[25];
    private final double[] ceilingBuffer = new double[25];
    private final double[] ridgedSurfaceBuffer = new double[25];
    private final double[] pillarBuffer = new double[25];
    private final BiomeWeightTable weightTable;

    public MidnightNoiseGenerator(Random random) {
        this.worldNoise = OctaveNoiseSampler.perlin(random, 3);
        this.worldNoise.setAmplitude(5.0);
        this.worldNoise.setFrequency(0.1);
        this.surfaceNoise = OctaveNoiseSampler.perlin(random, 8);
        this.surfaceNoise.setAmplitude(3.0);
        this.surfaceNoise.setFrequency(0.04);
        this.ceilingNoise = OctaveNoiseSampler.perlin(random, 6);
        this.ceilingNoise.setAmplitude(3.0);
        this.ceilingNoise.setFrequency(0.04);
        this.pillarNoise = new PerlinNoiseSampler(random);
        this.pillarNoise.setFrequency(0.2);
        this.ridgedSurfaceNoise = OctaveNoiseSampler.ridged(random, 3, 4.0);
        this.ridgedSurfaceNoise.setAmplitude(4.0);
        this.ridgedSurfaceNoise.setFrequency(0.08);
        this.weightTable = new BiomeWeightTable(2);
    }

    protected double[] populateNoise(int chunkX, int chunkZ, Biome[] biomeBuffer, CavernousBiome[] cavernousBiomeBuffer) {
        GenerationContext context = new GenerationContext(biomeBuffer, cavernousBiomeBuffer);
        this.worldNoise.sample3D(this.worldNoiseBuffer, chunkX * 4, 0.0, chunkZ * 4, 5, 65, 5);
        this.surfaceNoise.sample2D(this.surfaceBuffer, chunkX * 4, chunkZ * 4, 5, 5);
        this.ceilingNoise.sample2D(this.ceilingBuffer, chunkX * 4, chunkZ * 4, 5, 5);
        this.ridgedSurfaceNoise.sample2D(this.ridgedSurfaceBuffer, chunkX * 4, chunkZ * 4, 5, 5);
        Arrays.fill(this.pillarBuffer, 0.0);
        this.pillarNoise.sample2D(this.pillarBuffer, chunkX * 4, chunkZ * 4, 5, 5);
        int index = 0;
        int surfaceIndex = 0;
        for (int localZ = 0; localZ < 5; ++localZ) {
            for (int localX = 0; localX < 5; ++localX) {
                index = this.populateColumnNoise(context, index, surfaceIndex++, localX, localZ);
            }
        }
        return this.terrainBuffer;
    }

    private int populateColumnNoise(GenerationContext context, int index, int surfaceIndex, int localX, int localZ) {
        BiomeProperties properties = this.computeBiomeProperties(context, localX, localZ);
        float heightOrigin = 19.5f;
        float maxHeight = 64.0f;
        float minCaveHeight = 5.0f;
        float maxCaveHeight = 11.5f;
        float caveHeightRange = maxCaveHeight - minCaveHeight;
        float baseHeight = properties.baseHeight + heightOrigin;
        float cavernFloorHeight = properties.cavernFloorHeight * caveHeightRange + minCaveHeight;
        float cavernCeilingHeight = properties.cavernCeilingHeight * caveHeightRange + minCaveHeight;
        double cavernCenter = (double)(cavernFloorHeight + cavernCeilingHeight) / 2.0;
        double cavernHeight = cavernCeilingHeight - cavernFloorHeight;
        float heightVariation = properties.heightVariation * 0.9f + 0.1f;
        float cavernHeightVariation = properties.cavernHeightVariation * 0.9f + 0.1f;
        double perlinSurfaceNoise = (this.surfaceBuffer[surfaceIndex] + 1.5) / 3.0;
        double perlinCeilingNoise = (this.ceilingBuffer[surfaceIndex] + 1.5) / 3.0;
        double ridgedSurfaceNoise = (this.ridgedSurfaceBuffer[surfaceIndex] + 1.5) / 3.0;
        double pillarDensity = Math.pow((this.pillarBuffer[surfaceIndex] + 1.0) * 0.5, 4.0);
        double surfaceHeightVariationScale = Math.pow((double)heightVariation * 2.0, 3.0);
        double cavernHeightVariationScale = Math.pow((double)cavernHeightVariation * 2.0, 3.0);
        double surfaceHeight = perlinSurfaceNoise + (ridgedSurfaceNoise - perlinSurfaceNoise) * (double)properties.ridgeWeight;
        surfaceHeight = surfaceHeight * (double)heightVariation * 2.0 + (double)baseHeight;
        double cavernRegionStart = (double)cavernFloorHeight + perlinSurfaceNoise * (double)cavernHeightVariation * 2.0;
        double cavernRegionEnd = (double)cavernCeilingHeight + perlinCeilingNoise * 0.15;
        double curveRange = 2.0;
        RegionInterpolator.Region[] regions = new RegionInterpolator.Region[]{RegionInterpolator.region(0.0, cavernRegionStart, 2.5, curveRange), RegionInterpolator.region(cavernRegionStart, cavernRegionEnd, properties.cavernDensity, curveRange), RegionInterpolator.region(cavernRegionEnd, surfaceHeight, 3.5, curveRange), RegionInterpolator.region(surfaceHeight, maxHeight, surfaceHeight - (double)maxHeight, (double)maxHeight - surfaceHeight)};
        RegionInterpolator interpolator = new RegionInterpolator(regions, Curve.linear());
        for (int localY = 0; localY < 65; ++localY) {
            double surfaceWeight = MathHelper.func_151237_a((double)(((double)localY - cavernRegionEnd) / (surfaceHeight - cavernRegionEnd)), (double)0.0, (double)1.0);
            double cavernWeight = 1.0 - surfaceWeight;
            double densityBias = interpolator.get(localY);
            double cavernCenterDistance = Math.min(Math.abs((double)localY - cavernCenter) / cavernHeight, 1.0);
            double pillarFalloff = Math.max(1.0 - Math.pow(cavernCenterDistance, 2.0), 0.0) * 0.125;
            double sampledNoise = this.worldNoiseBuffer[index];
            double surfaceNoiseDensity = sampledNoise * surfaceHeightVariationScale;
            double cavernNoiseDensity = sampledNoise * cavernHeightVariationScale;
            double noiseDensity = surfaceNoiseDensity * surfaceWeight + cavernNoiseDensity * cavernWeight;
            this.terrainBuffer[index] = noiseDensity + (densityBias += Math.max(pillarDensity * 3.5 - pillarFalloff, 0.0) * cavernWeight * 5.0 * (double)properties.pillarWeight);
            ++index;
        }
        return index;
    }

    private BiomeProperties computeBiomeProperties(GenerationContext context, int localX, int localZ) {
        BiomeProperties properties = BIOME_PROPERTIES;
        properties.zero();
        float totalWeight = 0.0f;
        Biome originBiome = context.sampleNoiseBiome(localX, localZ);
        for (int neighborZ = -2; neighborZ <= 2; ++neighborZ) {
            for (int neighborX = -2; neighborX <= 2; ++neighborX) {
                Biome neighborBiome = context.sampleNoiseBiome(localX + neighborX, localZ + neighborZ);
                CavernousBiome neighborCavernBiome = context.sampleNoiseCavernBiome(localX + neighborX, localZ + neighborZ);
                SurfaceTerrainConfig terrainConfig = SurfaceBiome.getTerrainConfig(neighborBiome);
                float nBaseHeight = terrainConfig.getBaseHeight();
                float nHeightVariation = terrainConfig.getHeightVariation();
                float nRidgeWeight = terrainConfig.getRidgeWeight();
                float nDensityScale = terrainConfig.getDensityScale();
                CavernStructureConfig cavernStructureConfig = neighborCavernBiome.getConfig().getStructureConfig();
                float nCavernFloorHeight = cavernStructureConfig.getFloorHeight();
                float nCavernCeilingHeight = cavernStructureConfig.getCeilingHeight();
                float nCavernDensity = cavernStructureConfig.getCavernDensity();
                float nCavernHeightVariation = cavernStructureConfig.getHeightVariation();
                float nCavernPillarWeight = cavernStructureConfig.getPillarWeight();
                float biomeWeight = this.weightTable.get(neighborX, neighborZ) / (nBaseHeight + 2.0f);
                if (neighborBiome.func_185355_j() > originBiome.func_185355_j()) {
                    biomeWeight *= 2.0f;
                }
                properties.heightVariation += nHeightVariation * biomeWeight;
                properties.baseHeight += nBaseHeight * biomeWeight;
                properties.ridgeWeight += nRidgeWeight * biomeWeight;
                properties.densityScale += nDensityScale * biomeWeight;
                properties.cavernFloorHeight += nCavernFloorHeight * biomeWeight;
                properties.cavernCeilingHeight += nCavernCeilingHeight * biomeWeight;
                properties.cavernDensity += nCavernDensity * biomeWeight;
                properties.cavernHeightVariation += nCavernHeightVariation * biomeWeight;
                properties.pillarWeight += nCavernPillarWeight * biomeWeight;
                totalWeight += biomeWeight;
            }
        }
        properties.normalize(totalWeight);
        return properties;
    }

    private static class BiomeProperties {
        float heightVariation;
        float baseHeight;
        float densityScale;
        float ridgeWeight;
        float cavernFloorHeight;
        float cavernCeilingHeight;
        float cavernDensity;
        float cavernHeightVariation;
        float pillarWeight;

        private BiomeProperties() {
        }

        void zero() {
            this.heightVariation = 0.0f;
            this.baseHeight = 0.0f;
            this.ridgeWeight = 0.0f;
            this.densityScale = 0.0f;
            this.cavernFloorHeight = 0.0f;
            this.cavernCeilingHeight = 0.0f;
            this.cavernDensity = 0.0f;
            this.cavernHeightVariation = 0.0f;
            this.pillarWeight = 0.0f;
        }

        void normalize(float weight) {
            this.heightVariation /= weight;
            this.baseHeight /= weight;
            this.ridgeWeight /= weight;
            this.densityScale /= weight;
            this.cavernFloorHeight /= weight;
            this.cavernCeilingHeight /= weight;
            this.cavernDensity /= weight;
            this.cavernHeightVariation /= weight;
            this.pillarWeight /= weight;
        }
    }

    private static class GenerationContext {
        private final Biome[] biomeBuffer;
        private final CavernousBiome[] cavernousBiomeBuffer;

        private GenerationContext(Biome[] biomeBuffer, CavernousBiome[] cavernousBiomeBuffer) {
            this.biomeBuffer = biomeBuffer;
            this.cavernousBiomeBuffer = cavernousBiomeBuffer;
        }

        Biome sampleNoiseBiome(int x, int z) {
            return this.biomeBuffer[x + 2 + (z + 2) * 9];
        }

        CavernousBiome sampleNoiseCavernBiome(int x, int z) {
            return this.cavernousBiomeBuffer[x + 2 + (z + 2) * 9];
        }
    }
}

