/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldUtil {
    @Nullable
    public static BlockPos findSurface(World world, BlockPos pos, int maxSteps) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos);
        int steps = 0;
        while (!world.isSideSolid((BlockPos)mutablePos, EnumFacing.UP)) {
            mutablePos.func_189536_c(EnumFacing.DOWN);
            if (steps++ <= maxSteps) continue;
            return null;
        }
        mutablePos.func_189536_c(EnumFacing.UP);
        return mutablePos.func_185334_h();
    }

    @Nonnull
    public static BlockPos findSurfaceOrInput(World world, BlockPos pos, int maxSteps) {
        BlockPos surface = WorldUtil.findSurface(world, pos, maxSteps);
        return surface != null ? surface : pos;
    }

    public static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.func_177958_n(), b.func_177958_n()), Math.min(a.func_177956_o(), b.func_177956_o()), Math.min(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos min(Collection<BlockPos> positions) {
        if (positions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (BlockPos pos : positions) {
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        return new BlockPos(minX, minY, minZ);
    }

    public static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.func_177958_n(), b.func_177958_n()), Math.max(a.func_177956_o(), b.func_177956_o()), Math.max(a.func_177952_p(), b.func_177952_p()));
    }

    public static BlockPos max(Collection<BlockPos> positions) {
        if (positions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : positions) {
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= maxZ) continue;
            maxZ = pos.func_177952_p();
        }
        return new BlockPos(maxX, maxY, maxZ);
    }
}

