/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NavigatorFlying
extends PathNavigateFlying {
    public NavigatorFlying(EntityLiving entity, World world) {
        super(entity, world);
    }

    protected void func_75508_h() {
        boolean reachedWaypoint;
        if (this.field_75514_c == null) {
            return;
        }
        this.field_188561_o = this.field_75515_a.field_70130_N > 0.75f ? this.field_75515_a.field_70130_N / 2.0f : 0.75f - this.field_75515_a.field_70130_N / 2.0f;
        Vec3d pathPosition = this.field_75514_c.func_186310_f();
        boolean bl = reachedWaypoint = Math.abs(this.field_75515_a.field_70165_t - (pathPosition.field_72450_a + 0.5)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.field_70161_v - (pathPosition.field_72449_c + 0.5)) < (double)this.field_188561_o && Math.abs(this.field_75515_a.field_70163_u - pathPosition.field_72448_b) < 1.0;
        if (reachedWaypoint) {
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1);
        }
        this.simplifyPath(this.field_75514_c);
        this.func_179677_a(this.func_75502_i());
    }

    private void simplifyPath(Path path) {
        Vec3d entityPosition = this.func_75502_i();
        int width = MathHelper.func_76123_f((float)this.field_75515_a.field_70130_N);
        int height = MathHelper.func_76123_f((float)this.field_75515_a.field_70131_O);
        for (int i = path.func_75874_d() - 1; i >= path.func_75873_e(); --i) {
            if (!this.func_75493_a(entityPosition, path.func_75881_a((Entity)this.field_75515_a, i), width, height, width)) continue;
            path.func_75872_c(i);
            break;
        }
    }

    protected boolean func_75493_a(Vec3d origin, Vec3d target, int sizeX, int sizeY, int sizeZ) {
        int currentX = MathHelper.func_76128_c((double)origin.field_72450_a);
        int currentY = MathHelper.func_76128_c((double)origin.field_72448_b);
        int currentZ = MathHelper.func_76128_c((double)origin.field_72449_c);
        double deltaX = target.field_72450_a - origin.field_72450_a;
        double deltaY = target.field_72448_b - origin.field_72448_b;
        double deltaZ = target.field_72449_c - origin.field_72449_c;
        double distanceSquared = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        if (distanceSquared < 1.0E-8) {
            return false;
        }
        double step = 1.0 / Math.sqrt(distanceSquared);
        double stepX = 1.0 / Math.abs(deltaX *= step);
        double stepY = 1.0 / Math.abs(deltaY *= step);
        double stepZ = 1.0 / Math.abs(deltaZ *= step);
        double displacedX = (double)currentX - origin.field_72450_a;
        double displacedY = (double)currentY - origin.field_72448_b;
        double displacedZ = (double)currentZ - origin.field_72449_c;
        if (deltaX >= 0.0) {
            displacedX += 1.0;
        }
        if (deltaY >= 0.0) {
            displacedY += 1.0;
        }
        if (deltaZ >= 0.0) {
            displacedZ += 1.0;
        }
        displacedX /= deltaX;
        displacedY /= deltaY;
        displacedZ /= deltaZ;
        int signX = deltaX < 0.0 ? -1 : 1;
        int signY = deltaY < 0.0 ? -1 : 1;
        int signZ = deltaZ < 0.0 ? -1 : 1;
        int targetX = MathHelper.func_76128_c((double)target.field_72450_a);
        int targetY = MathHelper.func_76128_c((double)target.field_72448_b);
        int targetZ = MathHelper.func_76128_c((double)target.field_72449_c);
        int currentDeltaX = targetX - currentX;
        int currentDeltaY = targetY - currentY;
        int currentDeltaZ = targetZ - currentZ;
        while (currentDeltaX * signX > 0 || currentDeltaY * signY > 0 || currentDeltaZ * signZ > 0) {
            if (displacedX < displacedZ && displacedX <= displacedY) {
                displacedX += stepX;
                currentDeltaX = targetX - (currentX += signX);
            } else if (displacedY < displacedX && displacedY <= displacedZ) {
                displacedY += stepY;
                currentDeltaY = targetY - (currentY += signY);
            } else {
                displacedZ += stepZ;
                currentDeltaZ = targetZ - (currentZ += signZ);
            }
            if (this.canPassThrough(currentX, currentY, currentZ, sizeX, sizeY, sizeZ, origin, deltaX, deltaZ)) continue;
            return false;
        }
        return true;
    }

    private boolean canPassThrough(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vec3d origin, double deltaX, double deltaZ) {
        BlockPos min = new BlockPos(x, y, z);
        BlockPos max = new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)min, (BlockPos)max)) {
            Block block;
            double displacementZ;
            double displacementX = (double)pos.func_177958_n() + 0.5 - origin.field_72450_a;
            if (!(displacementX * deltaX + (displacementZ = (double)pos.func_177952_p() + 0.5 - origin.field_72449_c) * deltaZ >= 0.0) || (block = this.field_75513_b.func_180495_p(pos).func_177230_c()).func_176205_b((IBlockAccess)this.field_75513_b, pos)) continue;
            return false;
        }
        return true;
    }
}

