/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.biome;

import com.mushroom.midnight.common.biome.config.BiomeFeatureEntry;
import com.mushroom.midnight.common.biome.config.FeatureConfig;
import com.mushroom.midnight.common.world.SurfacePlacementLevel;
import com.mushroom.midnight.common.world.feature.FeatureSorting;
import com.mushroom.midnight.common.world.feature.IMidnightFeature;
import com.mushroom.midnight.common.world.feature.config.IPlacementConfig;
import java.util.Collection;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MidnightBiomeDecorator
extends BiomeDecorator {
    private final FeatureConfig config;
    private final SurfacePlacementLevel placementLevel;

    public MidnightBiomeDecorator(FeatureConfig config, SurfacePlacementLevel placementLevel) {
        this.config = config;
        this.placementLevel = placementLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180292_a(World world, Random random, Biome biome, BlockPos pos) {
        if (this.field_185425_a) {
            throw new RuntimeException("Already decorating");
        }
        try {
            this.field_185425_a = true;
            this.field_180294_c = pos;
            this.func_150513_a(biome, world, random);
        }
        finally {
            this.field_185425_a = false;
        }
    }

    protected void func_150513_a(Biome biome, World world, Random random) {
        ChunkPos chunkPos = new ChunkPos(this.field_180294_c);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(world, random, chunkPos));
        for (FeatureSorting pass : FeatureSorting.VALUES) {
            Collection<BiomeFeatureEntry> features = this.config.getFeatures(pass);
            for (BiomeFeatureEntry entry : features) {
                this.generateFeatureEntry(world, random, chunkPos, entry);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(world, random, chunkPos));
    }

    private void generateFeatureEntry(World world, Random random, ChunkPos chunkPos, BiomeFeatureEntry entry) {
        IMidnightFeature[] features = entry.getFeatures();
        IMidnightFeature feature = features[random.nextInt(features.length)];
        IPlacementConfig config = entry.getPlacementConfig();
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (BlockPos)this.field_180294_c, (DecorateBiomeEvent.Decorate.EventType)feature.getEventType())) {
            config.apply(world, this.placementLevel, random, this.field_180294_c, pos -> feature.placeFeature(world, random, (BlockPos)pos));
        }
    }
}

