/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import java.util.List;
import net.daveyx0.multimob.spawn.MMConfigSpawnEntry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MMSpawnEntry {
    private String entryName;
    private Class<? extends Entity> entityClass;
    private EntityLiving.SpawnPlacementType spawnType;
    private WeatherCondition weatherCondition;
    private EnumCreatureType creatureType;
    private int[] heightLevelRange;
    private int[] lightLevelRange;
    private int[] groupSizeRange;
    private List<Class<? extends Entity>> entitiesNear;
    private List<IBlockState> blocksNear;
    private List<IBlockState> spawnBlocks;
    private List<Biome> biomes;
    private List<BiomeDictionary.Type> biomeTypes;
    private List<String> structures;
    private List<Integer> dimensions;
    private boolean allowedOnPeaceful;
    private boolean overrideEntityCanSpawnHere;
    private boolean isAllowedToSpawn;
    private boolean needsLoadsOfSpace;
    private boolean needsToSeeSky;
    private int spawnFrequency;
    private int additionalRarity;
    private int spawnWeight;
    private int variantID;

    public MMSpawnEntry(String entryName, Class<? extends Entity> class1, MMConfigSpawnEntry config) {
        this.entryName = entryName;
        this.entityClass = class1;
        this.reloadInfoFromConfig(config);
    }

    public String toString() {
        return this.entryName + " " + this.entityClass.getName();
    }

    public void reloadInfoFromConfig(MMConfigSpawnEntry config) {
        this.spawnType = config.getSpawnPlacementType();
        this.heightLevelRange = config.getHeightLevelRange();
        this.lightLevelRange = config.getLightLevelRange();
        this.entitiesNear = config.getEntitiesNearList();
        this.blocksNear = config.getBlocksNearList();
        this.spawnBlocks = config.getSpawnBlockList();
        this.biomes = config.getBiomeList();
        this.biomeTypes = config.getBiomeTypeList();
        this.structures = config.getStructureList();
        this.dimensions = config.getDimensionIdList();
        this.allowedOnPeaceful = config.getAllowedOnPeaceful();
        this.overrideEntityCanSpawnHere = config.getOverridesEntityCanSpawnHere();
        this.isAllowedToSpawn = config.getIsAllowedToSpawn();
        this.needsLoadsOfSpace = config.getNeedsLoadsOfSpace();
        this.needsToSeeSky = config.getNeedsToSeeSky();
        this.spawnFrequency = config.getSpawnLimit();
        this.additionalRarity = config.getAdditionalRarity();
        this.weatherCondition = config.getWeatherCondition();
        this.spawnWeight = config.getSpawnWeight();
        this.creatureType = config.getCreatureType();
        this.groupSizeRange = config.getGroupSizeRange();
        this.variantID = config.getVariantID();
    }

    public String getEntryName() {
        return this.entryName;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public int getSpawnLimit() {
        return this.spawnFrequency;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public int getAdditionalRarity() {
        return this.additionalRarity;
    }

    public EntityLiving.SpawnPlacementType getSpawnPlacementType() {
        return this.spawnType;
    }

    public WeatherCondition getWeatherCondition() {
        return this.weatherCondition;
    }

    public EnumCreatureType getCreatureType() {
        return this.creatureType;
    }

    public int[] getHeightLevelRange() {
        return this.heightLevelRange;
    }

    public int[] getLightLevelRange() {
        return this.lightLevelRange;
    }

    public int[] getGroupSizeRange() {
        return this.groupSizeRange;
    }

    public List<Class<? extends Entity>> getEntitiesNearList() {
        return this.entitiesNear;
    }

    public List<IBlockState> getSpawnBlocksList() {
        return this.spawnBlocks;
    }

    public List<IBlockState> getBlocksNearList() {
        return this.blocksNear;
    }

    public List<Biome> getBiomes() {
        return this.biomes;
    }

    public List<BiomeDictionary.Type> getBiomeTypes() {
        return this.biomeTypes;
    }

    public List<Integer> getDimensions() {
        return this.dimensions;
    }

    public List<String> getStructures() {
        return this.structures;
    }

    public boolean getIsAllowedOnPeaceful() {
        return this.allowedOnPeaceful;
    }

    public boolean getOverrideCanGetSpawnHere() {
        return this.overrideEntityCanSpawnHere;
    }

    public boolean getIsAllowedToSpawn() {
        return this.isAllowedToSpawn;
    }

    public boolean getNeedsMoreSpace() {
        return this.needsLoadsOfSpace;
    }

    public boolean getNeedsToSeeSky() {
        return this.needsToSeeSky;
    }

    public int getVariantID() {
        return this.variantID;
    }

    static enum WeatherCondition {
        NONE,
        GENERAL_DOWNFALL,
        THUNDERSTORM,
        RAIN,
        SNOW;

    }
}

