/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import java.util.ArrayList;
import java.util.List;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.spawn.MMSpawnEntry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MMConfigSpawnEntry {
    private static String category1 = "spawnLimit";
    private static String category2 = "spawnAllowed";
    private static String category3 = "peacefulAllowed";
    private static String category4 = "addedRarity";
    private static String category5 = "spawnBiomeTypes";
    private static String category6 = "spawnBiomes";
    private static String category7 = "spawnDimensions";
    private static String category8 = "heightLevels";
    private static String category9 = "lightLevels";
    private static String category10 = "spawnType";
    private static String category11 = "weatherCondition";
    private static String category12 = "spawnBlocks";
    private static String category13 = "blocksNearSpawn";
    private static String category14 = "spawnStructures";
    private static String category15 = "entitiesNearSpawn";
    private static String category16 = "needsMoreSpace";
    private static String category17 = "needsToSeeSky";
    private static String category18 = "canOverrideSpawnChecks";
    private static String category19 = "creatureTypes";
    private static String category20 = "spawnWeights";
    private static String category21 = "spawnGroupSizes";
    private static String category22 = "spawnVariants";
    private String entryName;
    public String entityName;
    private final int defaultSpawnWeight;
    private final boolean defaultIsAllowedToSpawn;
    private String spawnType;
    private String weatherCondition;
    private String creatureType;
    private String[] entitiesNear;
    private String[] spawnBlocks;
    private String[] blocksNear;
    private String[] biomes;
    private String[] biomeTypes;
    private String[] structures;
    private int[] dimensions;
    private int[] heightLevels;
    private int[] lightLevels;
    private int[] groupSize;
    private boolean allowedOnPeaceful;
    private boolean overrideEntityCanSpawnHere;
    private boolean isAllowedToSpawn;
    private boolean needsLoadsOfSpace;
    private boolean needsToSeeSky;
    private int spawnFrequency;
    private int additionalRarity;
    private int spawnWeight;
    private int variantID;
    private String defaultSpawnType = "GROUND";
    private String defaultWeatherType = "NONE";
    private String defaultCreatureType = "MULTIMOBMONSTER";
    private String[] defaultEntitiesNear = new String[]{""};
    private String[] defaultSpawnBlocks = new String[]{""};
    private String[] defaultBlocksNear = new String[]{""};
    private String[] defaultBiomes = new String[]{""};
    private String[] defaultBiomeTypes = new String[]{""};
    private String[] defaultStructures = new String[]{""};
    private int[] defaultDimensions = new int[]{0};
    private int[] defaultHeightLevels = new int[]{-1, -1};
    private int[] defaultLightLevels = new int[]{-1, -1};
    private int[] defaultGroupSize = new int[]{1, 1};
    private boolean defaultAllowedOnPeaceful = false;
    private boolean defaultOverrideEntityCanSpawnHere = false;
    private boolean defaultNeedsLoadsOfSpace = false;
    private boolean defaultNeedsToSeeSky = false;
    private int defaultAdditionalRarity = -1;
    private int defaultSpawnFrequency = -1;
    private int defaultVariantID = -1;

    public MMConfigSpawnEntry(String entryName, String entityName) {
        this(entryName, entityName, 100, true);
        this.entryName = entryName;
        this.entityName = entityName;
    }

    public MMConfigSpawnEntry(String entryName, String entityName, int spawnWeight, boolean isAllowedToSpawn) {
        this.entryName = entryName;
        this.entityName = entityName;
        this.defaultSpawnWeight = spawnWeight;
        this.defaultIsAllowedToSpawn = isAllowedToSpawn;
    }

    public void load(Configuration config) {
        this.spawnFrequency = config.get(category1, this.entryName, this.defaultSpawnFrequency).getInt();
        this.isAllowedToSpawn = config.get(category2, this.entryName, this.defaultIsAllowedToSpawn).getBoolean();
        this.allowedOnPeaceful = config.get(category3, this.entryName, this.defaultAllowedOnPeaceful).getBoolean();
        this.additionalRarity = config.get(category4, this.entryName, this.defaultAdditionalRarity).getInt();
        this.biomeTypes = config.get(category5, this.entryName, this.defaultBiomeTypes).getStringList();
        this.biomes = config.get(category6, this.entryName, this.defaultBiomes).getStringList();
        this.dimensions = config.get(category7, this.entryName, this.defaultDimensions).getIntList();
        this.heightLevels = config.get(category8, this.entryName, this.defaultHeightLevels).getIntList();
        this.lightLevels = config.get(category9, this.entryName, this.defaultLightLevels).getIntList();
        this.spawnType = config.get(category10, this.entryName, this.defaultSpawnType).getString();
        this.weatherCondition = config.get(category11, this.entryName, this.defaultWeatherType).getString();
        this.spawnBlocks = config.get(category12, this.entryName, this.defaultSpawnBlocks).getStringList();
        this.blocksNear = config.get(category13, this.entryName, this.defaultBlocksNear).getStringList();
        this.structures = config.get(category14, this.entryName, this.defaultStructures).getStringList();
        this.entitiesNear = config.get(category15, this.entryName, this.defaultEntitiesNear).getStringList();
        this.needsLoadsOfSpace = config.get(category16, this.entryName, this.defaultNeedsLoadsOfSpace).getBoolean();
        this.needsToSeeSky = config.get(category17, this.entryName, this.defaultNeedsToSeeSky).getBoolean();
        this.overrideEntityCanSpawnHere = config.get(category18, this.entryName, this.defaultOverrideEntityCanSpawnHere).getBoolean();
        this.creatureType = config.get(category19, this.entryName, this.defaultCreatureType).getString();
        this.spawnWeight = config.get(category20, this.entryName, this.defaultSpawnWeight).getInt();
        this.groupSize = config.get(category21, this.entryName, this.defaultGroupSize).getIntList();
        this.variantID = config.get(category22, this.entryName, this.defaultVariantID).getInt();
    }

    public static void setupCategoryDescriptions(Configuration config) {
        config.addCustomCategoryComment(category1, "Spawn limit of this mob; if this limit is reached, the mob will no longer spawn until another one despawns.");
        config.addCustomCategoryComment(category2, "Determines if this spawn setting is enabled; if false the mob will not spawn");
        config.addCustomCategoryComment(category3, "Determines if the mob is allowed to spawn on Peaceful difficulty; if false the mob will not spawn on peaceful");
        config.addCustomCategoryComment(category4, "Adds an additional rarity check when spawning; the higher this number the lower the spawn successrate");
        config.addCustomCategoryComment(category5, "Biome Types this mob will spawn in; for a list of all different types check, the multimob config folder; requires capital letters and adding multiple will require the spawn biome to have all these types present! Example: FOREST");
        config.addCustomCategoryComment(category6, "Biomes this mob will spawn in; for a list of all different biomes present, check the multimob config folder; adding multiple will allow the mob to spawn in each of those biomes.");
        config.addCustomCategoryComment(category7, "Dimensions this mob will spawn in; they go by ID. Example: 0, -1 (This is the Overworld and the Nether)");
        config.addCustomCategoryComment(category8, "Height levels this mob will spawn in between; first number is min height, second is max. Putting -1 will ignore that height limit");
        config.addCustomCategoryComment(category9, "Light levels this mob will spawn in between; first number is min light, second is max. Putting -1 will ignore the light limit and putting -2 for both will make the check the same as normal hostile mobs.");
        config.addCustomCategoryComment(category10, "The spawn type this mob will use to check if they can spawn at a certain location; self explanatory. Valid entries: GROUND, WATER, AIR, LAVA");
        config.addCustomCategoryComment(category11, "The weather conditions this mob will spawn at; self explanatory. Valid entries: THUNDER, RAIN, SNOW, DOWNFALL (this means generally when there is downfall)");
        config.addCustomCategoryComment(category12, "Blocks or BlockStates this mob can spawn on; for a list of all different blockstates present, check the multimob config folder. This is NOT checked if the regular spawn checks are not overridden.");
        config.addCustomCategoryComment(category13, "Blocks or BlockStates that need to be near in order for this mob to spawn; for a list of all different blockstates present, check the multimob config folder. Adding multiple will require all those blocks to be near.");
        config.addCustomCategoryComment(category15, "Entities that need to be near in order for this mob to spawn; for a list of all different entities present, check the multimob config folder. Adding multiple will require all those entities to be near.");
        config.addCustomCategoryComment(category14, "Structures this mob can spawn inside of; for a list of all different vanilla structures present, check the multimob config folder. Adding multiple will allow the mob to spawn in each structure.");
        config.addCustomCategoryComment(category16, "Determines if the mob needs more space to spawn; if true the mob will need more air blocks around it to spawn");
        config.addCustomCategoryComment(category17, "Determines if the mob needs to be under the sky to spawn; if true the mob needs to be able to see the sky in order to spawn");
        config.addCustomCategoryComment(category18, "Determines if the spawn should use the mob's inherent spawn checks; if true it will not use them and instead use the spawn blocks setting to see which block to spawn on.");
        config.addCustomCategoryComment(category19, "Determine the creature type, which is used to determine the limit of each type that can spawn in the world. Only really useful for mod makers. Valid entries: MULTIMOBMONSTER, MULTIMOBPASSIVE, MULTIMOBWATER, MULTIMOBLAVA, MONSTER, CREATURE, AMBIENT, WATERCREATURE.");
        config.addCustomCategoryComment(category20, "Spawn weights are used to determine the frequency of the mob being chosen by the spawner. The higher this number, the more chance the mob has to spawn");
        config.addCustomCategoryComment(category21, "Spawn group size; determines the minimum and maximum amount of mobs that will appear for each spawn.");
        config.addCustomCategoryComment(category22, "The variant ID determines which Variant of the mob is used for this spawn setup. See the Variant Settings.");
    }

    public String getEntryName() {
        return this.entryName;
    }

    public EntityLiving.SpawnPlacementType getSpawnPlacementType() {
        if (this.spawnType.equals("LAVA")) {
            return MultiMob.IN_LAVA;
        }
        if (this.spawnType.equals("AIR")) {
            return EntityLiving.SpawnPlacementType.IN_AIR;
        }
        if (this.spawnType.equals("WATER")) {
            return EntityLiving.SpawnPlacementType.IN_WATER;
        }
        return EntityLiving.SpawnPlacementType.ON_GROUND;
    }

    public MMSpawnEntry.WeatherCondition getWeatherCondition() {
        if (this.weatherCondition.equals("DOWNFALL")) {
            return MMSpawnEntry.WeatherCondition.GENERAL_DOWNFALL;
        }
        if (this.weatherCondition.equals("THUNDER")) {
            return MMSpawnEntry.WeatherCondition.THUNDERSTORM;
        }
        if (this.weatherCondition.equals("RAIN")) {
            return MMSpawnEntry.WeatherCondition.RAIN;
        }
        if (this.weatherCondition.equals("SNOW")) {
            return MMSpawnEntry.WeatherCondition.SNOW;
        }
        return MMSpawnEntry.WeatherCondition.NONE;
    }

    public List<Class<? extends Entity>> getEntitiesNearList() {
        if (this.entitiesNear != null && !this.entitiesNear[0].equals("")) {
            ArrayList<Class<? extends Entity>> entryList = new ArrayList<Class<? extends Entity>>();
            for (String entry : this.entitiesNear) {
                EntityEntry entityEntry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entry));
                if (entityEntry == null) continue;
                entryList.add(entityEntry.getEntityClass());
            }
            return entryList;
        }
        return null;
    }

    public List<Biome> getBiomeList() {
        if (this.biomes != null && !this.biomes[0].equals("")) {
            ArrayList<Biome> entryList = new ArrayList<Biome>();
            for (String entry : this.biomes) {
                Biome biomeEntry = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(entry));
                if (biomeEntry == null) continue;
                entryList.add(biomeEntry);
            }
            return entryList;
        }
        return null;
    }

    public List<BiomeDictionary.Type> getBiomeTypeList() {
        if (this.biomeTypes != null && !this.biomeTypes[0].equals("")) {
            ArrayList<BiomeDictionary.Type> entryList = new ArrayList<BiomeDictionary.Type>();
            for (String entry : this.biomeTypes) {
                BiomeDictionary.Type biomeTypeEntry = BiomeDictionary.Type.getType((String)entry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
                if (biomeTypeEntry == null) continue;
                entryList.add(biomeTypeEntry);
            }
            return entryList;
        }
        return null;
    }

    public int[] getHeightLevelRange() {
        return this.heightLevels;
    }

    public int[] getLightLevelRange() {
        return this.lightLevels;
    }

    public List<IBlockState> getBlocksNearList() {
        if (this.blocksNear != null && !this.blocksNear[0].equals("")) {
            return this.createBlockStateList(this.blocksNear);
        }
        return null;
    }

    public List<IBlockState> getSpawnBlockList() {
        if (this.spawnBlocks != null && !this.spawnBlocks[0].equals("")) {
            return this.createBlockStateList(this.spawnBlocks);
        }
        return null;
    }

    public List<IBlockState> createBlockStateList(String[] array) {
        ArrayList<IBlockState> entryList = new ArrayList<IBlockState>();
        for (String entry : array) {
            Block blockEntry = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entry));
            if (blockEntry != null) {
                entryList.add(blockEntry.func_176223_P());
                continue;
            }
            for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
                for (IBlockState state : block.func_176194_O().func_177619_a()) {
                    if (!entry.equals(state.toString())) continue;
                    entryList.add(state);
                }
            }
        }
        return entryList;
    }

    public List<Integer> getDimensionIdList() {
        if (this.dimensions != null) {
            ArrayList<Integer> entryList = new ArrayList<Integer>();
            for (int entry : this.dimensions) {
                entryList.add(entry);
            }
            return entryList;
        }
        return null;
    }

    public boolean getAllowedOnPeaceful() {
        return this.allowedOnPeaceful;
    }

    public boolean getOverridesEntityCanSpawnHere() {
        return this.overrideEntityCanSpawnHere;
    }

    public boolean getIsAllowedToSpawn() {
        return this.isAllowedToSpawn;
    }

    public boolean getNeedsLoadsOfSpace() {
        return this.needsLoadsOfSpace;
    }

    public boolean getNeedsToSeeSky() {
        return this.needsToSeeSky;
    }

    public int getSpawnLimit() {
        return this.spawnFrequency;
    }

    public int getAdditionalRarity() {
        return this.additionalRarity;
    }

    public int getVariantID() {
        return this.variantID;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public EnumCreatureType getCreatureType() {
        if (this.creatureType.equals("MULTIMOBMONSTER")) {
            return MultiMob.MULTIMOB_MONSTER;
        }
        if (this.creatureType.equals("MULTIMOBPASSIVE")) {
            return MultiMob.MULTIMOB_PASSIVE;
        }
        if (this.creatureType.equals("MULTIMOBWATER")) {
            return MultiMob.MULTIMOB_WATER;
        }
        if (this.creatureType.equals("MULTIMOBLAVA")) {
            return MultiMob.MULTIMOB_LAVA;
        }
        if (this.creatureType.equals("CREATURE")) {
            return EnumCreatureType.CREATURE;
        }
        if (this.creatureType.equals("AMBIENT")) {
            return EnumCreatureType.AMBIENT;
        }
        if (this.creatureType.equals("WATERCREATURE")) {
            return EnumCreatureType.WATER_CREATURE;
        }
        return EnumCreatureType.MONSTER;
    }

    public int[] getGroupSizeRange() {
        return this.groupSize;
    }

    public List<String> getStructureList() {
        if (this.structures != null && !this.structures[0].equals("")) {
            ArrayList<String> entryList = new ArrayList<String>();
            for (String entry : this.structures) {
                entryList.add(entry);
            }
            return entryList;
        }
        return null;
    }

    public MMConfigSpawnEntry setSpawnType(String i) {
        this.defaultSpawnType = i;
        return this;
    }

    public MMConfigSpawnEntry setWeatherCondition(String i) {
        this.defaultWeatherType = i;
        return this;
    }

    public MMConfigSpawnEntry setEntitiesNear(String[] i) {
        this.defaultEntitiesNear = i;
        return this;
    }

    public MMConfigSpawnEntry setSpawnBlocks(String[] i) {
        this.defaultSpawnBlocks = i;
        return this;
    }

    public MMConfigSpawnEntry setBlocksNear(String[] i) {
        this.defaultBlocksNear = i;
        return this;
    }

    public MMConfigSpawnEntry setBiomes(String[] i) {
        this.defaultBiomes = i;
        return this;
    }

    public MMConfigSpawnEntry setBiomeTypes(String[] i) {
        this.defaultBiomeTypes = i;
        return this;
    }

    public MMConfigSpawnEntry setStructures(String[] i) {
        this.defaultStructures = i;
        return this;
    }

    public MMConfigSpawnEntry setDimensions(int[] i) {
        this.defaultDimensions = i;
        return this;
    }

    public MMConfigSpawnEntry setAllowedOnPeacful(boolean i) {
        this.defaultAllowedOnPeaceful = i;
        return this;
    }

    public MMConfigSpawnEntry setOverrideCanSpawnHere(boolean i) {
        this.defaultOverrideEntityCanSpawnHere = i;
        return this;
    }

    public MMConfigSpawnEntry setNeedsMoreSpace(boolean i) {
        this.defaultNeedsLoadsOfSpace = i;
        return this;
    }

    public MMConfigSpawnEntry setNeedsToSeeSky(boolean i) {
        this.defaultNeedsToSeeSky = i;
        return this;
    }

    public MMConfigSpawnEntry setAdditionalRarity(int i) {
        this.defaultAdditionalRarity = i;
        return this;
    }

    public MMConfigSpawnEntry setHeightLevel(int i, int j) {
        this.defaultHeightLevels[0] = i;
        this.defaultHeightLevels[1] = j;
        return this;
    }

    public MMConfigSpawnEntry setLightLevel(int i, int j) {
        this.defaultLightLevels[0] = i;
        this.defaultLightLevels[1] = j;
        return this;
    }

    public MMConfigSpawnEntry setSpawnLimit(int i) {
        this.defaultSpawnFrequency = i;
        return this;
    }

    public MMConfigSpawnEntry setCreatureType(String i) {
        this.defaultCreatureType = i;
        return this;
    }

    public MMConfigSpawnEntry setGroupSize(int i, int j) {
        this.defaultGroupSize[0] = i;
        this.defaultGroupSize[1] = j;
        return this;
    }

    public MMConfigSpawnEntry setVariantID(int i) {
        this.defaultVariantID = i;
        return this;
    }

    public MMConfigSpawnEntry setupBaseAnimalSpawnEntry(boolean overrideSpawnChecks) {
        this.defaultSpawnBlocks = new String[]{"minecraft:grass"};
        this.defaultLightLevels[0] = 9;
        this.defaultAllowedOnPeaceful = true;
        this.overrideEntityCanSpawnHere = overrideSpawnChecks;
        return this;
    }

    public MMConfigSpawnEntry setupBaseMobSpawnEntry(boolean overrideSpawnChecks) {
        this.defaultLightLevels[0] = -2;
        this.defaultLightLevels[1] = -2;
        this.overrideEntityCanSpawnHere = overrideSpawnChecks;
        return this;
    }
}

