/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.client.gui.GuiBarakoayaTrade;
import com.bobmowzie.mowziesmobs.server.ServerProxy;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaAttackTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIBarakoayaTrade;
import com.bobmowzie.mowziesmobs.server.ai.EntityAIBarakoayaTradeLook;
import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.trade.Trade;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.trade.TradeStore;
import com.bobmowzie.mowziesmobs.server.gui.GuiHandler;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoayaTrade;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBarakoaya
extends EntityBarakoa
implements GuiHandler.ContainerHolder,
LeaderSunstrikeImmune {
    private static final TradeStore DEFAULT = new TradeStore.Builder().addTrade(Items.field_151074_bl, 5, (Item)ItemHandler.BLOWGUN, 1, 6).addTrade(Items.field_151100_aR, 10, EnumDyeColor.BROWN.func_176767_b(), (Item)ItemHandler.DART, 8, 0, 6).addTrade(Items.field_151074_bl, 5, (Item)ItemHandler.SPEAR, 1, 4).addTrade(Items.field_151074_bl, 1, Item.func_150898_a((Block)BlockHandler.PAINTED_ACACIA), 2, 4).addTrade(Items.field_151100_aR, 16, EnumDyeColor.BROWN.func_176767_b(), Item.func_150898_a((Block)BlockHandler.PAINTED_ACACIA), 1, 0, 4).addTrade(Items.field_151100_aR, 10, EnumDyeColor.BROWN.func_176767_b(), Items.field_151077_bg, 2, 0, 2).addTrade(Items.field_151074_bl, 1, Items.field_151077_bg, 1, 2).addTrade(Items.field_151100_aR, 14, EnumDyeColor.BROWN.func_176767_b(), Items.field_151157_am, 2, 0, 2).addTrade(Items.field_151074_bl, 2, Items.field_151157_am, 1, 2).addTrade(Items.field_151127_ba, 3, Items.field_151074_bl, 5, 2).addTrade(Items.field_151076_bf, 1, Items.field_151074_bl, 3, 2).addTrade(Items.field_151040_l, 1, Items.field_151043_k, 2, 2).addTrade((Item)Items.field_151028_Y, 1, Items.field_151043_k, 4, 2).addTrade(Items.field_151052_q, 1, Items.field_151074_bl, 7, 2).build();
    private static final DataParameter<Optional<Trade>> TRADE = EntityDataManager.func_187226_a(EntityBarakoaya.class, ServerProxy.OPTIONAL_TRADE);
    private static final int MIN_OFFER_TIME = 6000;
    private static final int MAX_OFFER_TIME = 24000;
    private TradeStore tradeStore = TradeStore.EMPTY;
    private int timeOffering;
    private EntityPlayer customer;

    public EntityBarakoaya(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBarakoayaTrade(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBarakoayaTradeLook(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new BarakoaHurtByTargetAI(this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new BarakoaAttackTargetAI(this, EntityPlayer.class, 0, true, false));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityZombie.class, 0, true, true, null));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, 0, true, false, null));
        this.setWeapon(0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TRADE, (Object)Optional.absent());
    }

    public void setOfferingTrade(Trade trade) {
        this.func_184212_Q().func_187227_b(TRADE, (Object)Optional.fromNullable((Object)trade));
    }

    public Trade getOfferingTrade() {
        return (Trade)((Optional)this.func_184212_Q().func_187225_a(TRADE)).orNull();
    }

    public boolean isOfferingTrade() {
        if (this.func_184212_Q().func_187225_a(TRADE) instanceof Optional) {
            return ((Optional)this.func_184212_Q().func_187225_a(TRADE)).isPresent();
        }
        return false;
    }

    public void setCustomer(EntityPlayer customer) {
        this.customer = customer;
    }

    public EntityPlayer getCustomer() {
        return this.customer;
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    @Override
    protected boolean canHoldVaryingWeapons() {
        return false;
    }

    @Override
    public Container createContainer(World world, EntityPlayer player, int x, int y, int z) {
        return new ContainerBarakoayaTrade(this, player.field_71071_by, world);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(World world, EntityPlayer player, int x, int y, int z) {
        return new GuiBarakoayaTrade(this, player.field_71071_by, world);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if ((!this.isOfferingTrade() || this.timeOffering <= 0) && this.tradeStore.hasStock()) {
            this.setOfferingTrade(this.tradeStore.get(this.field_70146_Z));
            this.timeOffering = this.field_70146_Z.nextInt(18001) + 6000;
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.canTradeWith(player) && this.func_70638_az() == null && !this.field_70128_L) {
            this.setCustomer(player);
            if (!this.field_70170_p.field_72995_K) {
                GuiHandler.open(GuiHandler.BARAKOA_TRADE, player, this);
            }
            return true;
        }
        return false;
    }

    public boolean canTradeWith(EntityPlayer player) {
        if (this.isTrading()) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        return headStack.func_77973_b() instanceof BarakoaMask && this.isOfferingTrade();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.tradeStore = DEFAULT;
        return super.func_180482_a(difficulty, data);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("tradeStore", (NBTBase)this.tradeStore.serialize());
        if (this.isOfferingTrade()) {
            compound.func_74782_a("offeringTrade", (NBTBase)this.getOfferingTrade().serialize());
        }
        compound.func_74768_a("timeOffering", this.timeOffering);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.tradeStore = TradeStore.deserialize(compound.func_74775_l("tradeStore"));
        this.setOfferingTrade(Trade.deserialize(compound.func_74775_l("offeringTrade")));
        this.timeOffering = compound.func_74762_e("timeOffering");
    }
}

