/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.server.entity.EntityDart;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntityEggInfo;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityAxeAttack;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBlockSwapper;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBall;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityIceBreath;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityRing;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySolarBeam;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityBabyFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrozenController;
import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import com.bobmowzie.mowziesmobs.server.entity.lantern.EntityLantern;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.google.common.reflect.Reflection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mowziesmobs")
public enum EntityHandler {
    INSTANCE;

    public static final String BARAKOAYA_ID = "barakoaya";
    private static final Map<ResourceLocation, MowzieEntityEggInfo> entityEggs;
    private static int nextEntityId;

    @SubscribeEvent
    public static void register(RegistryEvent.Register<EntityEntry> event) {
        IForgeRegistry registry = event.getRegistry();
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityFoliaath.class, "foliaath", true, 4705339, 12598220, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBabyFoliaath.class, "baby_foliaath", false, 4705339, 12598220, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityWroughtnaut.class, "ferrous_wroughtnaut", true, 0x8C8C8C, 0xFFFFFF, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBarakoanToBarakoana.class, "barakoan_barakoana", false, 12215894, 16448120, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBarakoana.class, "barakoana", true, 12215894, 16448120, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBarakoaya.class, BARAKOAYA_ID, true, 12215894, 16448120, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBarakoanToPlayer.class, "barakoan_player", false, 12215894, 16448120, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBarako.class, "barako", true, 12215894, 0xFFFF00, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityFrostmaw.class, "frostmaw", true, 0xF7FAFF, 11521535, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityGrottol.class, "grottol", true, 0x777777, 12378367, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityLantern.class, "lantern", true, 7203328, 2316816, 64, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityNaga.class, "naga", true, 1394768, 9295705, 128, new Biome[0]);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySunstrike.class, "sunstrike", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySolarBeam.class, "solar_beam", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBoulder.class, "boulder", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityAxeAttack.class, "axe_attack", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityIceBreath.class, "icebreath", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityIceBall.class, "ice_ball", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityFrozenController.class, "frozen_controller", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityRing.class, "ring", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityDart.class, "dart", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityPoisonBall.class, "poison_ball", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntitySuperNova.class, "super_nova", 64);
        EntityHandler.registerEntity((IForgeRegistry<EntityEntry>)registry, EntityBlockSwapper.class, "block_swapper", 64);
    }

    public static void registerEntity(IForgeRegistry<EntityEntry> registry, Class<? extends EntityLiving> entityClass, String name, boolean addEgg, int mainColor, int subColor, int trackingDistance, Biome ... biomes) {
        Reflection.initialize((Class[])new Class[]{entityClass});
        int entityId = EntityHandler.nextEntityId();
        ResourceLocation res = new ResourceLocation("mowziesmobs", name);
        registry.register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(res, entityId).name(name).tracker(trackingDistance, 1, true).build());
        if (addEgg) {
            entityEggs.put(res, new MowzieEntityEggInfo(res, entityClass, mainColor, subColor));
        }
    }

    public static void registerEntity(IForgeRegistry<EntityEntry> registry, Class<? extends Entity> entityClass, String name, int trackingDistance) {
        int entityId = EntityHandler.nextEntityId();
        ResourceLocation res = new ResourceLocation("mowziesmobs", name);
        registry.register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(entityClass).id(res, entityId).name(name).tracker(trackingDistance, 1, true).build());
    }

    private static int nextEntityId() {
        return nextEntityId++;
    }

    public MowzieEntityEggInfo getEntityEggInfo(ResourceLocation id) {
        return entityEggs.get(id);
    }

    public boolean hasEntityEggInfo(ResourceLocation name) {
        return entityEggs.containsKey(name);
    }

    public EntityLiving createEntity(ResourceLocation id, World world) {
        EntityLiving entity = null;
        try {
            Class<? extends EntityLiving> clazz = EntityHandler.entityEggs.get((Object)id).clazz;
            if (clazz != null) {
                entity = clazz.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    public Iterator<MowzieEntityEggInfo> getEntityEggInfoIterator() {
        return entityEggs.values().iterator();
    }

    static {
        entityEggs = new LinkedHashMap<ResourceLocation, MowzieEntityEggInfo>();
    }
}

