/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particles.util;

import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particle.ParticleTextureStitcher;
import com.bobmowzie.mowziesmobs.client.particles.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particles.util.ParticleRibbon;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MowzieParticleBase
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    public float airDrag;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public float prevRed;
    public float prevGreen;
    public float prevBlue;
    public float prevAlpha;
    public boolean faceCamera;
    public float scale;
    public float prevScale;
    public float yaw;
    public float pitch;
    public float roll;
    public float prevYaw;
    public float prevPitch;
    public float prevRoll;
    public boolean emissive;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    ParticleComponent[] components;
    ParticleRibbon ribbon;

    protected MowzieParticleBase(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, double yaw, double pitch, double roll, double scale, double r, double g, double b, double a, double drag, double duration, boolean faceCamera, boolean emissive, float faceCameraAngle, ParticleComponent[] components) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.scale = (float)scale;
        this.field_70547_e = (int)duration;
        this.airDrag = (float)drag;
        this.faceCamera = faceCamera;
        this.yaw = (float)yaw;
        this.pitch = (float)pitch;
        this.roll = (float)roll;
        this.components = components;
        this.emissive = emissive;
        this.field_190014_F = faceCameraAngle;
        this.ribbon = null;
        for (ParticleComponent component : components) {
            component.init(this);
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.field_190015_G = this.field_190014_F;
        this.prevScale = this.scale;
    }

    public int func_70537_b() {
        return 1;
    }

    public int func_189214_a(float partialTick) {
        int i = super.func_189214_a(partialTick);
        if (this.emissive) {
            int k = i >> 16 & 0xFF;
            return 0xF0 | k << 16;
        }
        return i;
    }

    public void func_189213_a() {
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.prevScale = this.scale;
        this.prevYaw = this.yaw;
        this.prevPitch = this.pitch;
        this.prevRoll = this.roll;
        this.field_190015_G = this.field_190014_F;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevMotionX = this.field_187129_i;
        this.prevMotionY = this.field_187130_j;
        this.prevMotionZ = this.field_187131_k;
        for (ParticleComponent component : this.components) {
            component.preUpdate(this);
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
        this.field_187129_i *= (double)this.airDrag;
        this.field_187130_j *= (double)this.airDrag;
        this.field_187131_k *= (double)this.airDrag;
        for (ParticleComponent component : this.components) {
            component.postUpdate(this);
        }
        if (this.ribbon != null) {
            this.ribbon.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.ribbon.positions[0] = new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.ribbon.prevPositions[0] = this.getPrevPos();
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        Point3d[] vertices;
        this.field_82339_as = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.field_82339_as < 0.01) {
            this.field_82339_as = 0.01f;
        }
        this.field_70552_h = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.field_70553_i = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.field_70551_j = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.field_70544_f = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        if (!this.faceCamera) {
            rotationX = 1.0f;
            rotationZ = 1.0f;
            rotationXY = 0.0f;
            rotationXZ = 0.0f;
            rotationYZ = 0.0f;
        }
        float f = (float)this.field_94054_b / 16.0f;
        float f1 = f + 0.0624375f;
        float f2 = (float)this.field_94055_c / 16.0f;
        float f3 = f2 + 0.0624375f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            f = this.field_187119_C.func_94209_e();
            f1 = this.field_187119_C.func_94212_f();
            f2 = this.field_187119_C.func_94206_g();
            f3 = this.field_187119_C.func_94210_h();
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
        if (this.faceCamera && this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)MowzieParticleBase.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)MowzieParticleBase.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)MowzieParticleBase.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        Matrix4d boxTranslate = new Matrix4d();
        Matrix4d boxRotateX = new Matrix4d();
        Matrix4d boxRotateY = new Matrix4d();
        Matrix4d boxRotateZ = new Matrix4d();
        boxTranslate.set(new Vector3d((double)f5, (double)f6, (double)f7));
        boxRotateX.rotX((double)(this.prevPitch + (this.pitch - this.prevPitch) * partialTicks));
        boxRotateY.rotY((double)(this.prevYaw + (this.yaw - this.prevYaw) * partialTicks));
        boxRotateZ.rotZ((double)(this.prevRoll + (this.roll - this.prevRoll) * partialTicks));
        for (Point3d point3d : vertices = new Point3d[]{new Point3d(avec3d[0].field_72450_a, avec3d[0].field_72448_b, avec3d[0].field_72449_c), new Point3d(avec3d[1].field_72450_a, avec3d[1].field_72448_b, avec3d[1].field_72449_c), new Point3d(avec3d[2].field_72450_a, avec3d[2].field_72448_b, avec3d[2].field_72449_c), new Point3d(avec3d[3].field_72450_a, avec3d[3].field_72448_b, avec3d[3].field_72449_c)}) {
            if (!this.faceCamera) {
                boxRotateZ.transform(point3d);
                boxRotateY.transform(point3d);
                boxRotateX.transform(point3d);
            }
            boxTranslate.transform(point3d);
        }
        buffer.func_181662_b(vertices[0].getX(), vertices[0].getY(), vertices[0].getZ()).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(vertices[1].getX(), vertices[1].getY(), vertices[1].getZ()).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(vertices[2].getX(), vertices[2].getY(), vertices[2].getZ()).func_187315_a((double)f, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b(vertices[3].getX(), vertices[3].getY(), vertices[3].getZ()).func_187315_a((double)f, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        for (ParticleComponent particleComponent : this.components) {
            particleComponent.postRender(this, buffer, partialTicks, j, k);
        }
    }

    public boolean func_187111_c() {
        return true;
    }

    public float getAge() {
        return this.field_70546_d;
    }

    public float getMaxAge() {
        return this.field_70547_e;
    }

    public double getPosX() {
        return this.field_187126_f;
    }

    public void setPosX(double posX) {
        this.func_187109_b(posX, this.field_187127_g, this.field_187128_h);
    }

    public double getPosY() {
        return this.field_187127_g;
    }

    public void setPosY(double posY) {
        this.func_187109_b(this.field_187126_f, posY, this.field_187128_h);
    }

    public double getPosZ() {
        return this.field_187128_h;
    }

    public void setPosZ(double posZ) {
        this.func_187109_b(this.field_187126_f, this.field_187127_g, posZ);
    }

    public double getMotionX() {
        return this.field_187129_i;
    }

    public void setMotionX(double motionX) {
        this.field_187129_i = motionX;
    }

    public double getMotionY() {
        return this.field_187130_j;
    }

    public void setMotionY(double motionY) {
        this.field_187130_j = motionY;
    }

    public double getMotionZ() {
        return this.field_187131_k;
    }

    public void setMotionZ(double motionZ) {
        this.field_187131_k = motionZ;
    }

    public float getAngle() {
        return this.field_190014_F;
    }

    public void setAngle(float angle) {
        this.field_190014_F = angle;
    }

    public Vec3d getPrevPos() {
        return new Vec3d(this.field_187123_c, this.field_187124_d, this.field_187125_e);
    }

    public double getPrevPosX() {
        return this.field_187123_c;
    }

    public double getPrevPosY() {
        return this.field_187124_d;
    }

    public double getPrevPosZ() {
        return this.field_187125_e;
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public static void spawnParticle(World world, MMParticle particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, float faceCameraAngle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive) {
        particle.spawn(world, x, y, z, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(motionX, motionY, motionZ, yaw, pitch, roll, scale, r, g, b, a, drag, duration, faceCamera, emissive, Float.valueOf(faceCameraAngle), new ParticleComponent[0]));
    }

    public static void spawnParticle(World world, MMParticle particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, float faceCameraAngle, double scale, double r, double g, double b, double a, double drag, double duration, boolean emissive, ParticleComponent[] components) {
        particle.spawn(world, x, y, z, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(motionX, motionY, motionZ, yaw, pitch, roll, scale, r, g, b, a, drag, duration, faceCamera, emissive, Float.valueOf(faceCameraAngle), components));
    }

    public static final class ParticleBaseFactory
    extends ParticleFactory<ParticleBaseFactory, MowzieParticleBase> {
        public ParticleBaseFactory(ResourceLocation texture) {
            super(MowzieParticleBase.class, ParticleTextureStitcher.create(MowzieParticleBase.class, texture));
        }

        @Override
        public MowzieParticleBase createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new MowzieParticleBase(args.world, args.x, args.y, args.z, (Double)args.data[0], (Double)args.data[1], (Double)args.data[2], (Double)args.data[3], (Double)args.data[4], (Double)args.data[5], (Double)args.data[6], (Double)args.data[7], (Double)args.data[8], (Double)args.data[9], (Double)args.data[10], (Double)args.data[11], (Double)args.data[12], (Boolean)args.data[13], (Boolean)args.data[14], ((Float)args.data[15]).floatValue(), (ParticleComponent[])args.data[16]);
        }
    }
}

