/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen;

import com.elytradev.movingworld.repackage.com.elytradev.concrete.common.ConcreteLog;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.BlockStateResourceProvider;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.ConcreteResourcePack;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.EnumResourceType;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.IResourceHolder;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.resgen.ResourceProvider;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class ItemModelResourceProvider
extends ResourceProvider {
    private static String SIMPLE_ITEM_MODEL;
    private static String SIMPLE_BLOCK_MODEL;

    public ItemModelResourceProvider(ConcreteResourcePack resourcePack) {
        super(resourcePack);
    }

    @Override
    public boolean canProvide(String name) {
        return name.startsWith("assets/" + this.modID + "/models/item/") && name.endsWith(".json");
    }

    @Override
    public InputStream provide(String name) {
        ResourceLocation resource;
        String itemID = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf("."));
        Item itemFromLocation = this.resourcePack.getItem(name);
        String textureLocation = this.modID + ":items/" + itemID;
        Integer meta = this.resourcePack.getMetaFromName(name);
        if (itemFromLocation instanceof IResourceHolder && (resource = ((IResourceHolder)itemFromLocation).getResource(EnumResourceType.TEXTURE, meta)) != null) {
            textureLocation = resource.toString();
        }
        if (Block.func_149634_a((Item)itemFromLocation) != Blocks.field_150350_a) {
            if (itemFromLocation.getRegistryName().func_110623_a().equals(itemID)) {
                try {
                    String blockName = name.replace("/item/", "/block/");
                    if (this.resourcePack.realpackHasResourceName(blockName)) {
                        return this.resourcePack.getRealpackInputStreamByName(blockName);
                    }
                    return this.resourcePack.func_110591_a(blockName);
                }
                catch (IOException e) {
                    ConcreteLog.error("Failed to get item model for {}", name);
                }
            } else {
                String simpleBlockModel = SIMPLE_BLOCK_MODEL;
                simpleBlockModel = simpleBlockModel.replaceAll("%ALL%", textureLocation);
                return IOUtils.toInputStream((String)simpleBlockModel);
            }
        }
        String simpleItemModel = SIMPLE_ITEM_MODEL;
        simpleItemModel = simpleItemModel.replaceAll("%L0%", textureLocation);
        return IOUtils.toInputStream((String)simpleItemModel);
    }

    static {
        try {
            SIMPLE_ITEM_MODEL = Resources.toString((URL)ItemModelResourceProvider.class.getResource("concreteitemmodel.json"), (Charset)Charsets.UTF_8);
            SIMPLE_BLOCK_MODEL = Resources.toString((URL)BlockStateResourceProvider.class.getResource("concreteblockmodel.json"), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            ConcreteLog.error("Caught IOException loading concrete item and block model, things will definitely not work.", (Throwable)e);
        }
    }
}

