/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jabelarminecraft.movinglightsource.utilities;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Utilities {
    public static Block setBlockName(Block parBlock, String parBlockName) {
        parBlock.setRegistryName(parBlockName);
        return parBlock;
    }

    public static Item setItemName(Item parItem, String parItemName) {
        parItem.setRegistryName(parItemName);
        parItem.func_77655_b(parItemName);
        return parItem;
    }

    public static Entity getClosestEntity(World parWorld, BlockPos parPos, double parMaxDistance) {
        if (parMaxDistance <= 0.0) {
            return null;
        }
        Entity closest = null;
        double distanceSq = parMaxDistance * parMaxDistance;
        AxisAlignedBB aabb = new AxisAlignedBB((double)parPos.func_177958_n() - parMaxDistance, (double)parPos.func_177956_o() - parMaxDistance, (double)parPos.func_177952_p() - parMaxDistance, (double)parPos.func_177958_n() + parMaxDistance, (double)parPos.func_177956_o() + parMaxDistance, (double)parPos.func_177952_p() + parMaxDistance);
        List listEntitiesInRange = parWorld.func_72872_a(EntityLivingBase.class, aabb);
        listEntitiesInRange.addAll(parWorld.func_72872_a(EntityItem.class, aabb));
        listEntitiesInRange.addAll(parWorld.func_72872_a(EntityTippedArrow.class, aabb));
        for (Entity next : listEntitiesInRange) {
            if (!(Utilities.getDistanceSq(next.func_180425_c(), parPos) < distanceSq)) continue;
            closest = next;
        }
        return closest;
    }

    private static double getDistanceSq(BlockPos parPos1, BlockPos parPos2) {
        return (parPos1.func_177958_n() - parPos2.func_177958_n()) * (parPos1.func_177958_n() - parPos2.func_177958_n()) + (parPos1.func_177956_o() - parPos2.func_177956_o()) * (parPos1.func_177956_o() - parPos2.func_177956_o()) + (parPos1.func_177952_p() - parPos2.func_177952_p()) * (parPos1.func_177952_p() - parPos2.func_177952_p());
    }

    private static String stringToGolden(String parString, int parShineLocation, boolean parReturnToBlack) {
        int stringLength = parString.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        for (int i = 0; i < stringLength; ++i) {
            outputString = ((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 0L ? outputString + TextFormatting.WHITE + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 1L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 87L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : outputString + TextFormatting.GOLD + parString.substring(i, i + 1)));
        }
        if (parReturnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static String stringToGolden(String parString, int parShineLocation) {
        return Utilities.stringToGolden(parString, parShineLocation, false);
    }

    public static String multiLineTextFormatting(TextFormatting parTextFormatting, String parString) {
        String theString = "";
        String[] textStr = parString.split("\\r\\n|\\n|\\r");
        for (int i = 0; i < textStr.length; ++i) {
            theString = theString + parTextFormatting + textStr[i] + "\n";
        }
        return theString;
    }

    @Nullable
    public static RayTraceResult rayTrace(Entity theEntity, double reachDistance) {
        Vec3d startPos = theEntity.func_174824_e(0.0f);
        Vec3d lookVec = theEntity.func_70040_Z();
        Vec3d endPos = startPos.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return theEntity.field_70170_p.func_147447_a(startPos, endPos, false, true, true);
    }
}

