/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jabelarminecraft.movinglightsource.proxy;

import com.blogspot.jabelarminecraft.movinglightsource.EventHandler;
import com.blogspot.jabelarminecraft.movinglightsource.MainMod;
import com.blogspot.jabelarminecraft.movinglightsource.gui.GuiHandler;
import com.blogspot.jabelarminecraft.movinglightsource.tileentities.TileEntityMovingLightSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommonProxy {
    public void fmlLifeCycleEvent(FMLPreInitializationEvent event) {
        this.initConfig(event);
        this.registerTileEntities();
    }

    public void fmlLifeCycleEvent(FMLInitializationEvent event) {
        this.registerEventListeners();
        this.registerGuiHandlers();
    }

    private void registerGuiHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MainMod.instance, (IGuiHandler)new GuiHandler());
    }

    private void initConfig(FMLPreInitializationEvent event) {
        MainMod.configFile = event.getSuggestedConfigurationFile();
        System.out.println("Torches and Moving Light Sources config path = " + MainMod.configFile.getAbsolutePath());
        System.out.println("Config file exists = " + MainMod.configFile.canRead());
        MainMod.config = new Configuration(MainMod.configFile);
        this.syncConfig();
    }

    public void syncConfig() {
        MainMod.config.load();
        MainMod.allowHeldItemsToGiveOffLight = MainMod.config.get("general", "config.held_items.name", true, "config.held_items.tooltip").getBoolean(true);
        MainMod.allowTorchesToBurnEntities = MainMod.config.get("general", "config.torches_burn.name", true, "config.torches_burn.tooltip").getBoolean(true);
        MainMod.allowBurningEntitiesToGiveOffLight = MainMod.config.get("general", "config.burning_entities.name", true, "config.burning_entities.tooltip").getBoolean(true);
        MainMod.allowFireEnchantmentsToGiveOffLight = MainMod.config.get("general", "config.fire_enchantments.name", true, "config.fire_enchantments.tooltip").getBoolean(true);
        MainMod.allowEntityItemsToGiveOffLight = MainMod.config.get("general", "config.entity_items.name", true, "config.entity_items.tooltip").getBoolean(true);
        MainMod.config.save();
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityMovingLightSource.class, (ResourceLocation)new ResourceLocation("movinglightsource", "tileEntityMovingLightSource"));
    }

    private void registerEventListeners() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }
}

