/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jabelarminecraft.movinglightsource.blocks;

import com.blogspot.jabelarminecraft.movinglightsource.MainMod;
import com.blogspot.jabelarminecraft.movinglightsource.registries.BlockRegistry;
import com.blogspot.jabelarminecraft.movinglightsource.tileentities.TileEntityMovingLightSource;
import com.blogspot.jabelarminecraft.movinglightsource.utilities.Utilities;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMovingLightSource
extends Block
implements ITileEntityProvider {
    private static final HashMap<Item, Block> lightSourceList = new HashMap();
    private static final AxisAlignedBB THE_AABB = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);

    public BlockMovingLightSource(String parName) {
        super(Material.field_151579_a);
        Utilities.setBlockName(this, parName);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149675_a(false);
        this.func_149715_a(1.0f);
    }

    public static void initMapLightSources() {
        BlockMovingLightSource.addVanillaItemsToLightSourceList();
        BlockMovingLightSource.addModItemsToLightSourceList();
        BlockMovingLightSource.addModCompabilityItemsToLightSourceList();
        lightSourceList.entrySet().removeIf(entry -> entry.getKey() == Items.field_190931_a);
        BlockMovingLightSource.dumpLightSourceListToConsole();
    }

    private static void addVanillaItemsToLightSourceList() {
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150461_bJ), BlockRegistry.movinglightsource_15);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150428_aP), BlockRegistry.movinglightsource_15);
        lightSourceList.put(Items.field_151129_at, BlockRegistry.movinglightsource_15);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150426_aN), BlockRegistry.movinglightsource_15);
        lightSourceList.put(Items.field_151114_aO, BlockRegistry.movinglightsource_15);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_180398_cJ), BlockRegistry.movinglightsource_15);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_185764_cQ), BlockRegistry.movinglightsource_14);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150478_aa), BlockRegistry.movinglightsource_14);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150429_aA), BlockRegistry.movinglightsource_9);
        lightSourceList.put(Item.func_150898_a((Block)Blocks.field_150450_ax), BlockRegistry.movinglightsource_7);
    }

    private static void addModItemsToLightSourceList() {
        Set setModBlocksWithLight = ForgeRegistries.BLOCKS.getEntries();
        for (Map.Entry entry : setModBlocksWithLight) {
            if (((ResourceLocation)entry.getKey()).func_110624_b().contains("minecraft") || ((ResourceLocation)entry.getKey()).func_110624_b().contains("movinglightsource")) continue;
            try {
                int lightValue = ((Block)entry.getValue()).func_176223_P().getLightValue(null, null);
                if (lightValue <= 0) continue;
                BlockMovingLightSource lightBlock = BlockRegistry.movinglightsource_15;
                switch (((Block)entry.getValue()).func_176223_P().getLightValue(null, null)) {
                    case 14: {
                        lightBlock = BlockRegistry.movinglightsource_14;
                        break;
                    }
                    case 13: {
                        lightBlock = BlockRegistry.movinglightsource_13;
                        break;
                    }
                    case 12: {
                        lightBlock = BlockRegistry.movinglightsource_12;
                        break;
                    }
                    case 11: {
                        lightBlock = BlockRegistry.movinglightsource_11;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        lightBlock = BlockRegistry.movinglightsource_9;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        lightBlock = BlockRegistry.movinglightsource_7;
                    }
                }
                lightSourceList.put(Item.func_150898_a((Block)((Block)entry.getValue())), lightBlock);
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
    }

    private static void addModCompabilityItemsToLightSourceList() {
        if (Loader.isModLoaded((String)"jetorches")) {
            BlockMovingLightSource.jetorchesCompatibility();
        }
        if (Loader.isModLoaded((String)"fairylights")) {
            BlockMovingLightSource.fairylightsCompatibility();
        }
    }

    private static void jetorchesCompatibility() {
        Set setModBlocksWithLight = ForgeRegistries.BLOCKS.getEntries();
        for (Map.Entry entry : setModBlocksWithLight) {
            if (!((ResourceLocation)entry.getKey()).func_110624_b().contains("jetorches") || !((ResourceLocation)entry.getKey()).func_110623_a().contains("torch") && !((ResourceLocation)entry.getKey()).func_110623_a().contains("lamp")) continue;
            lightSourceList.put(Item.func_150898_a((Block)((Block)entry.getValue())), BlockRegistry.movinglightsource_14);
        }
        Set setModItemsWithLight = ForgeRegistries.ITEMS.getEntries();
        for (Map.Entry entry : setModItemsWithLight) {
            if (!((ResourceLocation)entry.getKey()).func_110624_b().contains("jetorches") || !((ResourceLocation)entry.getKey()).func_110623_a().contains("torch") && !((ResourceLocation)entry.getKey()).func_110623_a().contains("lamp")) continue;
            lightSourceList.put((Item)entry.getValue(), BlockRegistry.movinglightsource_14);
        }
    }

    private static void fairylightsCompatibility() {
        Set setModBlocksWithLight = ForgeRegistries.BLOCKS.getEntries();
        for (Map.Entry entry : setModBlocksWithLight) {
            if (!((ResourceLocation)entry.getKey()).func_110624_b().contains("fairylights")) continue;
            lightSourceList.put(Item.func_150898_a((Block)((Block)entry.getValue())), BlockRegistry.movinglightsource_14);
        }
        Set setModItemsWithLight = ForgeRegistries.ITEMS.getEntries();
        for (Map.Entry entry : setModItemsWithLight) {
            if (!((ResourceLocation)entry.getKey()).func_110624_b().contains("fairylights")) continue;
            lightSourceList.put((Item)entry.getValue(), BlockRegistry.movinglightsource_14);
        }
    }

    private static void dumpLightSourceListToConsole() {
        System.out.print("List of all light-emitting items is: ");
        for (Map.Entry<Item, Block> entry : lightSourceList.entrySet()) {
            System.out.print(entry.getKey().getRegistryName() + " ");
        }
        System.out.print("\n");
    }

    public BlockMovingLightSource(String parName, float parLightLevel) {
        this(parName);
        this.func_149715_a(parLightLevel);
    }

    public static boolean isHoldingLightItem(EntityLivingBase parLivingBase) {
        return BlockMovingLightSource.isLightItem(parLivingBase.func_184614_ca().func_77973_b()) || BlockMovingLightSource.isLightItem(parLivingBase.func_184592_cb().func_77973_b()) || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)parLivingBase.func_184614_ca()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)parLivingBase.func_184614_ca()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)parLivingBase.func_184592_cb()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)parLivingBase.func_184592_cb()) > 0;
    }

    public static boolean isHoldingLightItem(EntityItem theEntityItem) {
        return BlockMovingLightSource.isLightItem(theEntityItem.func_92059_d().func_77973_b());
    }

    public static boolean isLightItem(Item parItem) {
        return lightSourceList.containsKey(parItem);
    }

    public static Block lightBlockToPlace(@Nullable Entity parEntity) {
        if (parEntity == null || parEntity.field_70128_L) {
            return Blocks.field_150350_a;
        }
        if (parEntity instanceof EntityFireworkRocket) {
            return BlockRegistry.movinglightsource_12;
        }
        if (parEntity.func_70027_ad() && MainMod.allowBurningEntitiesToGiveOffLight) {
            return BlockRegistry.movinglightsource_15;
        }
        if (parEntity instanceof EntityLivingBase) {
            EntityLivingBase theEntityLiving = (EntityLivingBase)parEntity;
            if (MainMod.allowHeldItemsToGiveOffLight) {
                BlockMovingLightSource blockMainHand = (BlockMovingLightSource)lightSourceList.get(theEntityLiving.func_184614_ca().func_77973_b());
                BlockMovingLightSource blockOffHand = (BlockMovingLightSource)lightSourceList.get(theEntityLiving.func_184592_cb().func_77973_b());
                if (blockMainHand != null) {
                    if (blockOffHand != null) {
                        if (blockMainHand.func_176223_P().func_185906_d() >= blockOffHand.func_176223_P().func_185906_d()) {
                            return blockMainHand;
                        }
                        return blockOffHand;
                    }
                    return blockMainHand;
                }
                if (blockOffHand != null) {
                    return blockOffHand;
                }
            }
            if (MainMod.allowFireEnchantmentsToGiveOffLight && (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)theEntityLiving.func_184614_ca()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)theEntityLiving.func_184592_cb()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)theEntityLiving.func_184614_ca()) > 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)theEntityLiving.func_184592_cb()) > 0)) {
                return BlockRegistry.movinglightsource_14;
            }
        }
        if (parEntity instanceof EntityItem) {
            EntityItem theEntityItem = (EntityItem)parEntity;
            return lightSourceList.get(theEntityItem.func_92059_d().func_77973_b());
        }
        return Blocks.field_150350_a;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return THE_AABB;
    }

    @ParametersAreNonnullByDefault
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    @Deprecated
    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.func_185503_a(pos, start, end, blockState.func_185900_c((IBlockAccess)worldIn, pos));
    }

    @Nullable
    protected RayTraceResult func_185503_a(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        return null;
    }

    public boolean func_149662_c(IBlockState parIBlockState) {
        return false;
    }

    public boolean func_149686_d(IBlockState parIBlockState) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void onNeighborChange(IBlockAccess worldIn, BlockPos pos, BlockPos neighborPos) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Deprecated
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
    }

    @ParametersAreNonnullByDefault
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMovingLightSource();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }
}

