/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jabelarminecraft.movinglightsource;

import com.blogspot.jabelarminecraft.movinglightsource.blocks.BlockMovingLightSource;
import com.blogspot.jabelarminecraft.movinglightsource.proxy.CommonProxy;
import com.blogspot.jabelarminecraft.movinglightsource.utilities.Utilities;
import java.io.File;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="movinglightsource", name="Torches and Moving Light Sources", version="1.0.15", guiFactory="com.blogspot.jabelarminecraft.movinglightsource.gui.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class MainMod {
    public static final String MODID = "movinglightsource";
    public static final String MODNAME = "Torches and Moving Light Sources";
    public static final String MODVERSION = "1.0.15";
    private static final String MODDESCRIPTION = "Certain items such as torches and glowstone will give\noff light when wielded. You can also use torches to\nburn entities.";
    private static final String MODAUTHOR = "jabelar";
    private static final String MODCREDITS = "";
    private static final String MODURL = "https://minecraft.curseforge.com/search?search=jabelar";
    private static final String MODLOGO = "modconfiggraphic.png";
    public static File configFile;
    public static Configuration config;
    public static boolean allowHeldItemsToGiveOffLight;
    public static boolean allowBurningEntitiesToGiveOffLight;
    public static boolean allowTorchesToBurnEntities;
    public static boolean allowFireEnchantmentsToGiveOffLight;
    public static boolean allowEntityItemsToGiveOffLight;
    @Mod.Instance(value="movinglightsource")
    public static MainMod instance;
    @SidedProxy(clientSide="com.blogspot.jabelarminecraft.movinglightsource.proxy.ClientProxy", serverSide="com.blogspot.jabelarminecraft.movinglightsource.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void fmlLifeCycleEvent(FMLPreInitializationEvent event) {
        event.getModMetadata().autogenerated = false;
        event.getModMetadata().credits = TextFormatting.BLUE + MODCREDITS;
        event.getModMetadata().authorList.clear();
        event.getModMetadata().authorList.add(TextFormatting.RED + MODAUTHOR);
        event.getModMetadata().description = Utilities.multiLineTextFormatting(TextFormatting.YELLOW, MODDESCRIPTION);
        event.getModMetadata().url = MODURL;
        event.getModMetadata().updateJSON = "https://raw.githubusercontent.com/jabelar/MovingLightSource-1.12/master/src/main/resources/versionChecker.json";
        event.getModMetadata().logoFile = MODLOGO;
        proxy.fmlLifeCycleEvent(event);
    }

    @Mod.EventHandler
    public void fmlLifeCycleEvent(FMLInitializationEvent event) {
        BlockMovingLightSource.initMapLightSources();
        proxy.fmlLifeCycleEvent(event);
    }

    public static void saveProperties() {
        try {
            config.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        allowHeldItemsToGiveOffLight = true;
        allowBurningEntitiesToGiveOffLight = true;
        allowTorchesToBurnEntities = true;
        allowFireEnchantmentsToGiveOffLight = true;
        allowEntityItemsToGiveOffLight = true;
    }
}

