/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.jabelarminecraft.movinglightsource;

import com.blogspot.jabelarminecraft.movinglightsource.MainMod;
import com.blogspot.jabelarminecraft.movinglightsource.blocks.BlockMovingLightSource;
import com.blogspot.jabelarminecraft.movinglightsource.tileentities.TileEntityMovingLightSource;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(AttackEntityEvent event) {
        EntityPlayer thePlayer = event.getEntityPlayer();
        if (thePlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (thePlayer.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && MainMod.allowTorchesToBurnEntities) {
            event.getTarget().func_70015_d(10);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(TickEvent.WorldTickEvent event) {
        World theWorld = event.world;
        if (event.phase == TickEvent.Phase.START && !theWorld.field_72995_K) {
            EventHandler.processLightPlacementForEntities(theWorld);
        }
    }

    private static void processLightPlacementForEntities(World theWorld) {
        for (Entity theEntity : theWorld.func_175644_a(Entity.class, EntitySelectors.field_94557_a)) {
            Block lightBlockToPlace = BlockMovingLightSource.lightBlockToPlace(theEntity);
            if (!(lightBlockToPlace instanceof BlockMovingLightSource)) continue;
            BlockPos blockLocation = new BlockPos(MathHelper.func_76128_c((double)theEntity.field_70165_t), MathHelper.func_76128_c((double)(theEntity.field_70163_u - 0.2 - theEntity.func_70033_W())), MathHelper.func_76128_c((double)theEntity.field_70161_v)).func_177984_a();
            Block blockAtLocation = theWorld.func_180495_p(blockLocation).func_177230_c();
            if (blockAtLocation == Blocks.field_150350_a) {
                EventHandler.placeLightSourceBlock(theEntity, blockLocation, lightBlockToPlace, false);
                continue;
            }
            if (blockAtLocation instanceof BlockMovingLightSource) {
                if (blockAtLocation.func_176223_P().func_185906_d() == lightBlockToPlace.func_176223_P().func_185906_d()) continue;
                EventHandler.placeLightSourceBlock(theEntity, blockLocation, lightBlockToPlace, false);
                continue;
            }
            blockLocation.func_177984_a();
            blockAtLocation = theWorld.func_180495_p(blockLocation).func_177230_c();
            if (blockAtLocation == Blocks.field_150350_a) {
                EventHandler.placeLightSourceBlock(theEntity, blockLocation, lightBlockToPlace, false);
                continue;
            }
            if (!(blockAtLocation instanceof BlockMovingLightSource) || blockAtLocation.func_176223_P().func_185906_d() == lightBlockToPlace.func_176223_P().func_185906_d()) continue;
            EventHandler.placeLightSourceBlock(theEntity, blockLocation, lightBlockToPlace, false);
        }
    }

    private static void placeLightSourceBlock(Entity theEntity, BlockPos blockLocation, Block theLightBlock, boolean isFlashlight) {
        theEntity.field_70170_p.func_175656_a(blockLocation, theLightBlock.func_176223_P());
        TileEntity theTileEntity = theEntity.field_70170_p.func_175625_s(blockLocation);
        if (theTileEntity instanceof TileEntityMovingLightSource) {
            TileEntityMovingLightSource theTileEntityMovingLightSource = (TileEntityMovingLightSource)theTileEntity;
            theTileEntityMovingLightSource.setEntity(theEntity);
            theTileEntityMovingLightSource.setFlashlight(isFlashlight);
        }
    }
}

