/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.ServerUtils;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CitizenChatHandler
implements ICitizenChatHandler {
    private final EntityCitizen citizen;

    public CitizenChatHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void notifyDeath(DamageSource damageSource) {
        if (this.citizen.getCitizenColonyHandler().getColony() != null && this.citizen.getCitizenData() != null) {
            IJob job = this.citizen.getCitizenJobHandler().getColonyJob();
            if (job != null) {
                TextComponentTranslation component = new TextComponentTranslation("tile.blockhuttownhall.messageworkerdead", new Object[]{new TextComponentTranslation(job.getName(), new Object[0]), this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, damageSource.field_76373_n});
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), component.func_150261_e(), new Object[0]);
            } else {
                LanguageHandler.sendPlayersMessage(this.citizen.getCitizenColonyHandler().getColony().getImportantMessageEntityPlayers(), "tile.blockhuttownhall.messagecolonistdead", this.citizen.getCitizenData().getName(), (int)this.citizen.field_70165_t, (int)this.citizen.field_70163_u, (int)this.citizen.field_70161_v, damageSource.field_76373_n);
            }
        }
    }

    @Override
    public void sendLocalizedChat(String key, Object ... msg) {
        if (msg == null) {
            return;
        }
        TextComponentTranslation requiredItem = msg.length == 0 ? new TextComponentTranslation(key, new Object[0]) : new TextComponentTranslation(key, msg);
        TextComponentString citizenDescription = new TextComponentString(" ");
        citizenDescription.func_150258_a(this.citizen.func_95999_t()).func_150258_a(": ");
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            TextComponentString colonyDescription = new TextComponentString(" at " + this.citizen.getCitizenColonyHandler().getColony().getName() + ":");
            Set<EntityPlayer> players = this.citizen.getCitizenColonyHandler().getColony().getMessageEntityPlayers();
            EntityPlayer owner = ServerUtils.getPlayerFromUUID(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.getCitizenColonyHandler().getColony().getPermissions().getOwner());
            if (owner != null) {
                players.remove(owner);
                LanguageHandler.sendPlayerMessage(owner, this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName(), citizenDescription, requiredItem);
            }
            LanguageHandler.sendPlayersMessage(players, this.citizen.getCitizenJobHandler().getColonyJob() == null ? "" : this.citizen.getCitizenJobHandler().getColonyJob().getName(), colonyDescription, citizenDescription, requiredItem);
        }
    }
}

