/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIRequestSmelter<J extends AbstractJobCrafter>
extends AbstractEntityAICrafting<J> {
    private static final double BASE_XP_GAIN = 5.0;

    public AbstractEntityAIRequestSmelter(@NotNull J smelteryJob) {
        super(smelteryJob);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.START_USING_FURNACE, this::fillUpFurnace, 1), new AITarget((IAIState)AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE, this::retrieveSmeltableFromFurnace, 1));
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingSmelterCrafter.class;
    }

    private BlockPos getPositionOfOvenToRetrieveFrom() {
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            int countInResultSlot;
            TileEntity entity = this.world.func_175625_s(pos);
            if (!(entity instanceof TileEntityFurnace)) continue;
            TileEntityFurnace furnace = (TileEntityFurnace)entity;
            int n = countInResultSlot = ItemStackUtils.isEmpty(furnace.func_70301_a(2)) != false ? 0 : furnace.func_70301_a(2).func_190916_E();
            if (furnace.func_145950_i() || countInResultSlot <= 0 || !ItemStackUtils.isEmpty(furnace.func_70301_a(0)).booleanValue()) continue;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return pos;
        }
        return null;
    }

    @Override
    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> ItemStackUtils.isEmpty(stack) == false && new Stack((ItemStack)stack).matches(inputStorage.getItemStack());
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), predicate)) continue;
            if (InventoryUtils.hasItemInProvider(this.getOwnBuilding(), predicate)) {
                this.needsCurrently = predicate;
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
                TileEntityFurnace furnace;
                TileEntity entity = this.world.func_175625_s(pos);
                if (!(entity instanceof TileEntityFurnace) || !(furnace = (TileEntityFurnace)entity).func_70301_a(2).func_77969_a(storage.getPrimaryOutput()) && !furnace.func_70301_a(0).func_77969_a(storage.getCleanedInput().get(0).getItemStack())) continue;
                return AIWorkerState.CRAFT;
            }
            this.currentRecipeStorage = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    private IAIState retrieveSmeltableFromFurnace() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
        if (this.walkTo == null || this.currentRequest == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (!(entity instanceof TileEntityFurnace) || ItemStackUtils.isEmpty(((TileEntityFurnace)entity).func_70301_a(2)).booleanValue()) {
            this.walkTo = null;
            return AIWorkerState.START_WORKING;
        }
        this.walkTo = null;
        this.extractFromFurnace((TileEntityFurnace)entity);
        int resultCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), stack -> this.currentRecipeStorage.getPrimaryOutput().func_77969_a(stack));
        if (resultCount > 0) {
            this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
            this.incrementActionsDoneAndDecSaturation();
        }
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    private void extractFromFurnace(TileEntityFurnace furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((IInventory)furnace), 2, (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
        this.worker.getCitizenExperienceHandler().addExperience(5.0);
        this.incrementActionsDoneAndDecSaturation();
    }

    private IAIState checkIfAbleToSmelt(int amountOfFuel) {
        for (BlockPos pos : ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces()) {
            TileEntity entity = this.world.func_175625_s(pos);
            if (entity instanceof TileEntityFurnace) {
                if (((TileEntityFurnace)entity).func_145950_i()) continue;
                TileEntityFurnace furnace = (TileEntityFurnace)entity;
                if ((amountOfFuel <= 0 || !ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace)) && !ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) && (amountOfFuel <= 0 || !ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) continue;
                this.walkTo = pos;
                return AIWorkerState.START_USING_FURNACE;
            }
            if (this.world.func_180495_p(pos).func_177230_c() instanceof BlockFurnace) continue;
            ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).removeFromFurnaces(pos);
        }
        return this.getState();
    }

    private IAIState fillUpFurnace() {
        if (((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noFurnace", new Object[0]), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkTo == null || this.world.func_180495_p(this.walkTo).func_177230_c() != Blocks.field_150460_al) {
            this.walkTo = null;
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(this.walkTo)) {
            this.setDelay(2);
            return this.getState();
        }
        TileEntity entity = this.world.func_175625_s(this.walkTo);
        if (entity instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)entity;
            Predicate<ItemStack> smeltable = stack -> this.currentRecipeStorage.getCleanedInput().get(0).getItemStack().func_77969_a(stack);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), smeltable) && (ItemStackUtils.hasFuelInFurnaceAndNoSmeltable(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), smeltable, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 0);
            }
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b) && (ItemStackUtils.hasSmeltableInFurnaceAndNoFuel(furnace) || ItemStackUtils.hasNeitherFuelNorSmeltAble(furnace))) {
                InventoryUtils.transferXOfFirstSlotInItemHandlerWithIntoInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b, 64, (IItemHandler)new InvWrapper((IInventory)furnace), 1);
            }
        } else if (!(this.world.func_180495_p(this.walkTo).func_177230_c() instanceof BlockFurnace)) {
            ((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).removeFromFurnaces(this.walkTo);
        }
        this.walkTo = null;
        this.setDelay(5);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        int amountOfFuelInInv;
        if (this.currentRecipeStorage == null) {
            this.setDelay(20);
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBuilding()) {
            this.setDelay(5);
            return this.getState();
        }
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRecipeStorage.getIntermediate() != Blocks.field_150460_al) {
            return super.craft();
        }
        if (this.getOwnBuilding(AbstractBuildingSmelterCrafter.class).getCopyOfAllowedItems().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceUser.noFuel", new Object[0]), ChatPriority.BLOCKING));
            }
            return this.getState();
        }
        if (((AbstractBuildingSmelterCrafter)this.getOwnBuilding()).getFurnaces().isEmpty()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.noFurnace", new Object[0]), ChatPriority.BLOCKING));
            }
            this.setDelay(5);
            return AIWorkerState.START_WORKING;
        }
        BlockPos posOfOven = this.getPositionOfOvenToRetrieveFrom();
        if (posOfOven != null) {
            this.walkTo = posOfOven;
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.retrieving", new Object[0])});
            return AIWorkerState.RETRIEVING_END_PRODUCT_FROM_FURNACE;
        }
        int amountOfFuelInBuilding = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), TileEntityFurnace::func_145954_b);
        if (amountOfFuelInBuilding + (amountOfFuelInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), TileEntityFurnace::func_145954_b)) <= 0 && !((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(StackList.class))) {
            this.worker.getCitizenData().createRequestAsync(new StackList(this.getOwnBuilding(AbstractBuildingSmelterCrafter.class).getAllowedFuel(), "com.minecolonies.coremod.request.burnable"));
        }
        if (amountOfFuelInBuilding > 0 && amountOfFuelInInv == 0) {
            this.needsCurrently = TileEntityFurnace::func_145954_b;
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return this.checkIfAbleToSmelt(amountOfFuelInBuilding + amountOfFuelInInv);
    }
}

