/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.jetbrains.annotations.NotNull;

public class WhereAmICommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "whereami";
    public static final String NONE = "No colony close at all.";
    public static final String NONE_CLOSE = "You're not inside any colony, the closest colony is approx %.2f blocks away.";
    public static final String INSIDE = "You're inside colony %s with id: %s, the colony center is approx %.2f blocks away.";

    public WhereAmICommand() {
        super(new String[0]);
    }

    public WhereAmICommand(String ... parents) {
        super(parents);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        this.executeShared(server, sender);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        this.executeShared(server, sender);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            Log.getLogger().info("In the console...");
            return;
        }
        BlockPos playerPos = sender.func_180425_c();
        IColony colony = IColonyManager.getInstance().getClosestColony(server.func_130014_f_(), playerPos);
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NONE));
            return;
        }
        BlockPos center = colony.getCenter();
        double distance = BlockPosUtil.getDistanceSquared(center, new BlockPos(playerPos.func_177958_n(), center.func_177956_o(), playerPos.func_177952_p()));
        if (!IColonyManager.getInstance().isCoordinateInAnyColony(sender.func_130014_f_(), playerPos)) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(NONE_CLOSE, Math.sqrt(distance))));
            return;
        }
        String colonyName = colony.getName();
        String id = Integer.toString(colony.getID());
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(INSIDE, colonyName, id, Math.sqrt(distance))));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

