/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.sounds;

import com.minecolonies.api.sounds.AbstractWorkerSounds;
import com.minecolonies.api.sounds.ModSoundEvents;
import com.minecolonies.api.util.SoundUtils;
import java.util.Random;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class FishermanSounds
extends AbstractWorkerSounds {
    private static final int NUMBER_OF_SOUNDS = 2;
    private static final Random rand = new Random();

    @Override
    public void playSound(World worldIn, BlockPos position, boolean isFemale, double saturation) {
        switch (rand.nextInt(3)) {
            case 1: {
                SoundEvent generalPhrases = isFemale ? Female.generalPhrases : Male.generalPhrases;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, generalPhrases, this.getPhraseChance());
                break;
            }
            case 2: {
                SoundEvent noises = isFemale ? Female.noises : Male.noises;
                SoundUtils.playSoundAtCitizenWithChance(worldIn, position, noises, this.getBasicSoundChance());
                break;
            }
        }
    }

    @Override
    public String getWorkerString() {
        return "Fisherman";
    }

    @Override
    public void playInteractionSound(World world, BlockPos position, boolean female) {
    }

    public static final class Male {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.fisherman.male.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.fisherman.male.noise");
        public static final SoundEvent iGotOne = ModSoundEvents.getSoundID("mob.fisherman.male.iGotOne");
        public static final SoundEvent needFishingRod = ModSoundEvents.getSoundID("mob.fisherman.male.needFishingRod");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.fisherman.male.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.fisherman.male.badWeather");

        private Male() {
        }
    }

    public static final class Female {
        public static final SoundEvent generalPhrases = ModSoundEvents.getSoundID("mob.fisherman.female.generalPhrases");
        public static final SoundEvent noises = ModSoundEvents.getSoundID("mob.fisherman.female.noise");
        public static final SoundEvent iGotOne = ModSoundEvents.getSoundID("mob.fisherman.female.iGotOne");
        public static final SoundEvent needFishingRod = ModSoundEvents.getSoundID("mob.fisherman.female.needFishingRod");
        public static final SoundEvent offToBed = ModSoundEvents.getSoundID("mob.fisherman.female.offToBed");
        public static final SoundEvent badWeather = ModSoundEvents.getSoundID("mob.fisherman.female.badWeather");

        private Female() {
        }
    }
}

