/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.views.ScrollingContainer;
import com.ldtteam.blockout.views.ScrollingList;

public class ScrollingListContainer
extends ScrollingContainer {
    private int listElementHeight = 0;

    ScrollingListContainer(ScrollingList owner) {
        super(owner);
    }

    public void refreshElementPanes(ScrollingList.DataProvider dataProvider, PaneParams listNodeParams) {
        int numElements;
        int n = numElements = dataProvider != null ? dataProvider.getElementCount() : 0;
        if (dataProvider != null) {
            for (int i = 0; i < numElements; ++i) {
                Pane child;
                if (i < this.children.size()) {
                    child = (Pane)((Object)this.children.get(i));
                } else {
                    child = Loader.createFromPaneParams(listNodeParams, this);
                    if (child == null) continue;
                    if (i == 0) {
                        this.listElementHeight = child.getHeight();
                    }
                }
                child.setPosition(0, i * this.listElementHeight);
                dataProvider.updateElement(i, child);
            }
        }
        while (this.children.size() > numElements) {
            this.removeChild((Pane)((Object)this.children.get(numElements)));
        }
        this.computeContentHeight();
    }

    public int getListElementIndexByPane(Pane pane) {
        Pane parentPane;
        for (parentPane = pane; parentPane != null && parentPane.getParent() != this; parentPane = parentPane.getParent()) {
        }
        if (parentPane == null) {
            return -1;
        }
        return this.getChildren().indexOf((Object)parentPane);
    }

    @Override
    public Pane findPaneForClick(int mx, int my) {
        Pane child;
        if (this.children.isEmpty() || this.listElementHeight == 0) {
            return null;
        }
        int listElement = my / this.listElementHeight;
        if (listElement < this.children.size() && (child = (Pane)((Object)this.children.get(listElement))).canHandleClick(mx, my)) {
            return child;
        }
        return null;
    }
}

